/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import com.onesignal.OneSignalDbHelper;

class OneSignalCacheCleaner {
    private static String OS_DELETE_OLD_CACHED_DATA = "OS_DELETE_OLD_CACHED_DATA";

    OneSignalCacheCleaner() {
    }

    static synchronized void cleanOldCachedData(final Context context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
                OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(context);
                SQLiteDatabase writableDb = dbHelper.getWritableDbWithRetries();
                OneSignalCacheCleaner.cleanInAppMessagingCache();
                OneSignalCacheCleaner.cleanNotificationCache(writableDb);
            }
        }, OS_DELETE_OLD_CACHED_DATA).start();
    }

    static void cleanInAppMessagingCache() {
    }

    static void cleanNotificationCache(SQLiteDatabase writableDb) {
        OneSignalCacheCleaner.cleanOldNotificationData(writableDb);
        OneSignalCacheCleaner.cleanOldUniqueOutcomeEventNotificationsCache(writableDb);
    }

    private static void cleanOldNotificationData(SQLiteDatabase writableDb) {
        writableDb.delete("notification", "created_time < " + (System.currentTimeMillis() / 1000L - 604800L), null);
    }

    static void cleanOldUniqueOutcomeEventNotificationsCache(SQLiteDatabase writableDb) {
        writableDb.delete("cached_unique_outcome_notification", "NOT EXISTS(SELECT NULL FROM notification n WHERE n.notification_id = notification_id)", null);
    }
}

