/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class OSInAppMessageAction {
    @NonNull
    String clickId;
    @Nullable
    public String clickName;
    @Nullable
    public OSInAppMessageActionUrlType urlTarget;
    @Nullable
    public String clickUrl;
    public boolean firstClick;
    public boolean closesMessage;

    OSInAppMessageAction(@NonNull JSONObject json) {
        this.clickId = json.optString("id", null);
        this.clickName = json.optString("name", null);
        this.clickUrl = json.optString("url", null);
        this.urlTarget = OSInAppMessageActionUrlType.fromString(json.optString("url_target", null));
        if (this.urlTarget == null) {
            this.urlTarget = OSInAppMessageActionUrlType.IN_APP_WEBVIEW;
        }
        this.closesMessage = json.optBoolean("close", true);
    }

    public JSONObject toJSONObject() {
        JSONObject mainObj = new JSONObject();
        try {
            mainObj.put("click_name", (Object)this.clickName);
            mainObj.put("click_url", (Object)this.clickUrl);
            mainObj.put("first_click", this.firstClick);
            mainObj.put("closes_message", this.closesMessage);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mainObj;
    }

    public static enum OSInAppMessageActionUrlType {
        IN_APP_WEBVIEW("webview"),
        BROWSER("browser"),
        REPLACE_CONTENT("replacement");

        private String text;

        private OSInAppMessageActionUrlType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static OSInAppMessageActionUrlType fromString(String text) {
            for (OSInAppMessageActionUrlType type : OSInAppMessageActionUrlType.values()) {
                if (!type.text.equalsIgnoreCase(text)) continue;
                return type;
            }
            return null;
        }

        public JSONObject toJSONObject() {
            JSONObject mainObj = new JSONObject();
            try {
                mainObj.put("url_type", (Object)this.text);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return mainObj;
        }
    }
}

