/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.OSDynamicTriggerTimer;
import com.onesignal.OSInAppMessageController;
import com.onesignal.OSTrigger;
import com.onesignal.OneSignal;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimerTask;

class OSDynamicTriggerController {
    private final OSDynamicTriggerControllerObserver observer;
    private static final double REQUIRED_ACCURACY = 0.3;
    private static final long DEFAULT_LAST_IN_APP_TIME_AGO = 999999L;
    private final ArrayList<String> scheduledMessages = new ArrayList();
    static Date sessionLaunchTime = new Date();

    OSDynamicTriggerController(OSDynamicTriggerControllerObserver triggerObserver) {
        this.observer = triggerObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dynamicTriggerShouldFire(final OSTrigger trigger) {
        if (trigger.value == null) {
            return false;
        }
        ArrayList<String> arrayList = this.scheduledMessages;
        synchronized (arrayList) {
            if (!(trigger.value instanceof Number)) {
                return false;
            }
            long currentTimeInterval = 0L;
            switch (trigger.kind) {
                case SESSION_TIME: {
                    currentTimeInterval = new Date().getTime() - sessionLaunchTime.getTime();
                    break;
                }
                case TIME_SINCE_LAST_IN_APP: {
                    if (OSInAppMessageController.getController().isDisplayingInApp()) {
                        return false;
                    }
                    Date lastTimeAppDismissed = OSInAppMessageController.getController().lastTimeInAppDismissed;
                    currentTimeInterval = lastTimeAppDismissed == null ? 999999L : new Date().getTime() - lastTimeAppDismissed.getTime();
                }
            }
            long requiredTimeInterval = (long)(((Number)trigger.value).doubleValue() * 1000.0);
            if (OSDynamicTriggerController.evaluateTimeIntervalWithOperator(requiredTimeInterval, currentTimeInterval, trigger.operatorType)) {
                return true;
            }
            long offset = requiredTimeInterval - currentTimeInterval;
            if (offset <= 0L) {
                return false;
            }
            if (this.scheduledMessages.contains(trigger.triggerId)) {
                return false;
            }
            OSDynamicTriggerTimer.scheduleTrigger(new TimerTask(){

                @Override
                public void run() {
                    OSDynamicTriggerController.this.scheduledMessages.remove(trigger.triggerId);
                    OSDynamicTriggerController.this.observer.messageTriggerConditionChanged();
                }
            }, trigger.triggerId, offset);
            this.scheduledMessages.add(trigger.triggerId);
        }
        return false;
    }

    private static boolean evaluateTimeIntervalWithOperator(double timeInterval, double currentTimeInterval, OSTrigger.OSTriggerOperator operator) {
        switch (operator) {
            case LESS_THAN: {
                return currentTimeInterval < timeInterval;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return currentTimeInterval <= timeInterval || OSDynamicTriggerController.roughlyEqual(timeInterval, currentTimeInterval);
            }
            case GREATER_THAN: {
                return currentTimeInterval > timeInterval;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return currentTimeInterval >= timeInterval || OSDynamicTriggerController.roughlyEqual(timeInterval, currentTimeInterval);
            }
            case EQUAL_TO: {
                return OSDynamicTriggerController.roughlyEqual(timeInterval, currentTimeInterval);
            }
            case NOT_EQUAL_TO: {
                return !OSDynamicTriggerController.roughlyEqual(timeInterval, currentTimeInterval);
            }
        }
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Attempted to apply an invalid operator on a time-based in-app-message trigger: " + operator.toString());
        return false;
    }

    private static boolean roughlyEqual(double left, double right) {
        return Math.abs(left - right) < 0.3;
    }

    static interface OSDynamicTriggerControllerObserver {
        public void messageTriggerConditionChanged();
    }
}

