/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.onesignal.OSViewUtils;

class DraggableRelativeLayout
extends RelativeLayout {
    private static final int MARGIN_PX_SIZE = OSViewUtils.dpToPx(28);
    private static final int EXTRA_PX_DISMISS = OSViewUtils.dpToPx(64);
    private DraggableListener mListener;
    private ViewDragHelper mDragHelper;
    private boolean dismissing;
    private Params params;

    public DraggableRelativeLayout(Context context) {
        super(context);
        this.setClipChildren(false);
        this.createDragHelper();
    }

    void setListener(DraggableListener listener) {
        this.mListener = listener;
    }

    void setParams(Params params) {
        this.params = params;
        params.offScreenYPos = params.messageHeight + params.posY + (Resources.getSystem().getDisplayMetrics().heightPixels - params.messageHeight - params.posY) + DraggableRelativeLayout.EXTRA_PX_DISMISS;
        params.dismissingYVelocity = OSViewUtils.dpToPx(3000);
        if (params.dragDirection == 0) {
            params.offScreenYPos = -params.messageHeight - DraggableRelativeLayout.MARGIN_PX_SIZE;
            params.dismissingYVelocity = -params.dismissingYVelocity;
            params.dismissingYPos = params.offScreenYPos / 3;
        } else {
            params.dismissingYPos = params.messageHeight / 3 + params.maxYPos * 2;
        }
    }

    private void createDragHelper() {
        this.mDragHelper = ViewDragHelper.create((ViewGroup)this, (float)1.0f, (ViewDragHelper.Callback)new ViewDragHelper.Callback(){
            private int lastYPos;

            public boolean tryCaptureView(@NonNull View child, int pointerId) {
                return true;
            }

            public int clampViewPositionVertical(@NonNull View child, int top, int dy) {
                this.lastYPos = top;
                if (((DraggableRelativeLayout)DraggableRelativeLayout.this).params.dragDirection == 1 ? top < ((DraggableRelativeLayout)DraggableRelativeLayout.this).params.maxYPos : top > ((DraggableRelativeLayout)DraggableRelativeLayout.this).params.maxYPos) {
                    return ((DraggableRelativeLayout)DraggableRelativeLayout.this).params.maxYPos;
                }
                return top;
            }

            public int clampViewPositionHorizontal(@NonNull View child, int right, int dy) {
                return ((DraggableRelativeLayout)DraggableRelativeLayout.this).params.maxXPos;
            }

            public void onViewReleased(@NonNull View releasedChild, float xvel, float yvel) {
                int settleDestY = ((DraggableRelativeLayout)DraggableRelativeLayout.this).params.maxYPos;
                if (!DraggableRelativeLayout.this.dismissing) {
                    if (((DraggableRelativeLayout)DraggableRelativeLayout.this).params.dragDirection == 1) {
                        if (this.lastYPos > DraggableRelativeLayout.this.params.dismissingYPos || yvel > (float)DraggableRelativeLayout.this.params.dismissingYVelocity) {
                            settleDestY = DraggableRelativeLayout.this.params.offScreenYPos;
                            DraggableRelativeLayout.this.dismissing = true;
                            if (DraggableRelativeLayout.this.mListener != null) {
                                DraggableRelativeLayout.this.mListener.onDismiss();
                            }
                        }
                    } else if (this.lastYPos < DraggableRelativeLayout.this.params.dismissingYPos || yvel < (float)DraggableRelativeLayout.this.params.dismissingYVelocity) {
                        settleDestY = DraggableRelativeLayout.this.params.offScreenYPos;
                        DraggableRelativeLayout.this.dismissing = true;
                        if (DraggableRelativeLayout.this.mListener != null) {
                            DraggableRelativeLayout.this.mListener.onDismiss();
                        }
                    }
                }
                if (DraggableRelativeLayout.this.mDragHelper.settleCapturedViewAt(((DraggableRelativeLayout)DraggableRelativeLayout.this).params.maxXPos, settleDestY)) {
                    ViewCompat.postInvalidateOnAnimation((View)DraggableRelativeLayout.this);
                }
            }
        });
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.dismissing) {
            return true;
        }
        this.mDragHelper.processTouchEvent(event);
        return false;
    }

    public void computeScroll() {
        super.computeScroll();
        boolean settling = this.mDragHelper.continueSettling(true);
        if (settling) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void dismiss() {
        this.dismissing = true;
        this.mDragHelper.smoothSlideViewTo((View)this, this.getLeft(), this.params.offScreenYPos);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    static class Params {
        static final int DRAGGABLE_DIRECTION_UP = 0;
        static final int DRAGGABLE_DIRECTION_DOWN = 1;
        int posY;
        int maxYPos;
        int maxXPos;
        int height;
        int messageHeight;
        int dragDirection;
        private int dismissingYVelocity;
        private int offScreenYPos;
        private int dismissingYPos;

        Params() {
        }
    }

    static abstract class DraggableListener {
        DraggableListener() {
        }

        void onDismiss() {
        }
    }
}

