/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.OSViewUtils;
import java.lang.ref.WeakReference;

class OSSystemConditionController {
    private static final String TAG = OSSystemConditionController.class.getCanonicalName();
    private final OSSystemConditionObserver systemConditionObserver;

    OSSystemConditionController(OSSystemConditionObserver systemConditionObserver) {
        this.systemConditionObserver = systemConditionObserver;
    }

    boolean systemConditionsAvailable() {
        if (ActivityLifecycleHandler.curActivity == null) {
            return false;
        }
        boolean keyboardUp = OSViewUtils.isKeyboardUp(new WeakReference<Activity>(ActivityLifecycleHandler.curActivity));
        if (keyboardUp) {
            ActivityLifecycleHandler.setSystemConditionObserver(TAG, this.systemConditionObserver);
        }
        return !keyboardUp;
    }

    static interface OSSystemConditionObserver {
        public void messageTriggerConditionChanged();
    }
}

