/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalPrefs;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Scanner;
import org.json.JSONObject;

class OneSignalRestClient {
    static final String CACHE_KEY_GET_TAGS = "CACHE_KEY_GET_TAGS";
    static final String CACHE_KEY_REMOTE_PARAMS = "CACHE_KEY_REMOTE_PARAMS";
    private static final String BASE_URL = "https://onesignal.com/api/v1/";
    private static final int TIMEOUT = 120000;
    private static final int GET_TIMEOUT = 60000;

    OneSignalRestClient() {
    }

    private static int getThreadTimeout(int timeout) {
        return timeout + 5000;
    }

    public static void put(final String url, final JSONObject jsonBody, final ResponseHandler responseHandler) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OneSignalRestClient.makeRequest(url, "PUT", jsonBody, responseHandler, 120000, null);
            }
        }).start();
    }

    public static void post(final String url, final JSONObject jsonBody, final ResponseHandler responseHandler) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OneSignalRestClient.makeRequest(url, "POST", jsonBody, responseHandler, 120000, null);
            }
        }).start();
    }

    public static void get(final String url, final ResponseHandler responseHandler, final @NonNull String cacheKey) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OneSignalRestClient.makeRequest(url, null, null, responseHandler, 60000, cacheKey);
            }
        }).start();
    }

    public static void getSync(String url, ResponseHandler responseHandler, @NonNull String cacheKey) {
        OneSignalRestClient.makeRequest(url, null, null, responseHandler, 60000, cacheKey);
    }

    public static void putSync(String url, JSONObject jsonBody, ResponseHandler responseHandler) {
        OneSignalRestClient.makeRequest(url, "PUT", jsonBody, responseHandler, 120000, null);
    }

    public static void postSync(String url, JSONObject jsonBody, ResponseHandler responseHandler) {
        OneSignalRestClient.makeRequest(url, "POST", jsonBody, responseHandler, 120000, null);
    }

    private static void makeRequest(final String url, final String method, final JSONObject jsonBody, final ResponseHandler responseHandler, final int timeout, final String cacheKey) {
        if (method != null && OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName(null)) {
            return;
        }
        final Thread[] callbackThread = new Thread[1];
        Thread connectionThread = new Thread(new Runnable(){

            @Override
            public void run() {
                callbackThread[0] = OneSignalRestClient.startHTTPConnection(url, method, jsonBody, responseHandler, timeout, cacheKey);
            }
        }, "OS_HTTPConnection");
        connectionThread.start();
        try {
            connectionThread.join(OneSignalRestClient.getThreadTimeout(timeout));
            if (connectionThread.getState() != Thread.State.TERMINATED) {
                connectionThread.interrupt();
            }
            if (callbackThread[0] != null) {
                callbackThread[0].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Thread startHTTPConnection(String url, String method, JSONObject jsonBody, ResponseHandler responseHandler, int timeout, @Nullable String cacheKey) {
        Thread callbackThread;
        int httpResponse = -1;
        HttpURLConnection con = null;
        try {
            String eTag;
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OneSignalRestClient: Making request to: https://onesignal.com/api/v1/" + url);
            con = OneSignalRestClient.newHttpURLConnection(url);
            con.setUseCaches(false);
            con.setConnectTimeout(timeout);
            con.setReadTimeout(timeout);
            con.setRequestProperty("SDK-Version", "onesignal/android/031009");
            if (jsonBody != null) {
                con.setDoInput(true);
            }
            if (method != null) {
                con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                con.setRequestMethod(method);
                con.setDoOutput(true);
            }
            if (jsonBody != null) {
                String strJsonBody = jsonBody.toString();
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OneSignalRestClient: " + method + " SEND JSON: " + strJsonBody);
                byte[] sendBytes = strJsonBody.getBytes("UTF-8");
                con.setFixedLengthStreamingMode(sendBytes.length);
                OutputStream outputStream = con.getOutputStream();
                outputStream.write(sendBytes);
            }
            if (cacheKey != null && (eTag = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_ETAG_PREFIX_" + cacheKey, null)) != null) {
                con.setRequestProperty("if-none-match", eTag);
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OneSignalRestClient: Adding header if-none-match: " + eTag);
            }
            httpResponse = con.getResponseCode();
            OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "OneSignalRestClient: After con.getResponseCode to: https://onesignal.com/api/v1/" + url);
            switch (httpResponse) {
                case 304: {
                    String cachedResponse = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_HTTP_CACHE_PREFIX_" + cacheKey, null);
                    OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OneSignalRestClient: " + (method == null ? "GET" : method) + " - Using Cached response due to 304: " + cachedResponse);
                    callbackThread = OneSignalRestClient.callResponseHandlerOnSuccess(responseHandler, cachedResponse);
                    return callbackThread;
                }
                case 200: {
                    String eTag2;
                    OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OneSignalRestClient: Successfully finished request to: https://onesignal.com/api/v1/" + url);
                    InputStream inputStream = con.getInputStream();
                    Scanner scanner = new Scanner(inputStream, "UTF-8");
                    String json = scanner.useDelimiter("\\A").hasNext() ? scanner.next() : "";
                    scanner.close();
                    OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OneSignalRestClient: " + (method == null ? "GET" : method) + " RECEIVED JSON: " + json);
                    if (cacheKey != null && (eTag2 = con.getHeaderField("etag")) != null) {
                        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OneSignalRestClient: Response has etag of " + eTag2 + " so caching the response.");
                        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_ETAG_PREFIX_" + cacheKey, eTag2);
                        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_HTTP_CACHE_PREFIX_" + cacheKey, json);
                    }
                    callbackThread = OneSignalRestClient.callResponseHandlerOnSuccess(responseHandler, json);
                    return callbackThread;
                }
                default: {
                    Scanner scanner;
                    OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OneSignalRestClient: Failed request to: https://onesignal.com/api/v1/" + url);
                    InputStream inputStream = con.getErrorStream();
                    if (inputStream == null) {
                        inputStream = con.getInputStream();
                    }
                    if (inputStream != null) {
                        scanner = new Scanner(inputStream, "UTF-8");
                        String json = scanner.useDelimiter("\\A").hasNext() ? scanner.next() : "";
                        scanner.close();
                        OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "OneSignalRestClient: " + method + " RECEIVED JSON: " + json);
                    } else {
                        OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "OneSignalRestClient: " + method + " HTTP Code: " + httpResponse + " No response body!");
                    }
                    callbackThread = OneSignalRestClient.callResponseHandlerOnFailure(responseHandler, httpResponse, null, null);
                    return callbackThread;
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof ConnectException || t instanceof UnknownHostException) {
                OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "OneSignalRestClient: Could not send last request, device is offline. Throwable: " + t.getClass().getName());
            } else {
                OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "OneSignalRestClient: " + method + " Error thrown from network stack. ", t);
            }
            callbackThread = OneSignalRestClient.callResponseHandlerOnFailure(responseHandler, httpResponse, null, t);
            return callbackThread;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    private static Thread callResponseHandlerOnSuccess(final ResponseHandler handler, final String response) {
        if (handler == null) {
            return null;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                handler.onSuccess(response);
            }
        });
        thread.start();
        return thread;
    }

    private static Thread callResponseHandlerOnFailure(final ResponseHandler handler, final int statusCode, final String response, final Throwable throwable) {
        if (handler == null) {
            return null;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                handler.onFailure(statusCode, response, throwable);
            }
        });
        thread.start();
        return thread;
    }

    private static HttpURLConnection newHttpURLConnection(String url) throws IOException {
        return (HttpURLConnection)new URL(BASE_URL + url).openConnection();
    }

    static abstract class ResponseHandler {
        ResponseHandler() {
        }

        void onSuccess(String response) {
        }

        void onFailure(int statusCode, String response, Throwable throwable) {
        }
    }
}

