/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.support.v4.content.WakefulBroadcastReceiver;
import com.onesignal.BadgeCountUpdater;
import com.onesignal.GenerateNotification;
import com.onesignal.NotificationExtenderService;
import com.onesignal.OSNotificationPayload;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class NotificationBundleProcessor {
    static final String DEFAULT_ACTION = "__DEFAULT__";

    NotificationBundleProcessor() {
    }

    static void ProcessFromGCMIntentService(Context context, Bundle bundle, NotificationExtenderService.OverrideSettings overrideSettings) {
        try {
            boolean restoring = bundle.getBoolean("restoring", false);
            JSONObject jsonPayload = new JSONObject(bundle.getString("json_payload"));
            if (!restoring && OneSignal.notValidOrDuplicated(context, jsonPayload)) {
                return;
            }
            if (bundle.containsKey("android_notif_id")) {
                if (overrideSettings == null) {
                    overrideSettings = new NotificationExtenderService.OverrideSettings();
                }
                overrideSettings.androidNotificationId = bundle.getInt("android_notif_id");
            }
            NotificationBundleProcessor.Process(context, restoring, jsonPayload, overrideSettings);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static int Process(Context context, boolean restoring, JSONObject jsonPayload, NotificationExtenderService.OverrideSettings overrideSettings) {
        boolean showAsAlert = OneSignal.getInAppAlertNotificationEnabled() && OneSignal.isAppActive();
        int notificationId = overrideSettings != null && overrideSettings.androidNotificationId != null ? overrideSettings.androidNotificationId.intValue() : new Random().nextInt();
        GenerateNotification.fromJsonPayload(context, restoring, notificationId, jsonPayload, showAsAlert, overrideSettings);
        if (!restoring) {
            NotificationBundleProcessor.saveNotification(context, jsonPayload, false, notificationId);
            try {
                JSONObject jsonObject = new JSONObject(jsonPayload.toString());
                jsonObject.put("notificationId", notificationId);
                OneSignal.handleNotificationReceived(NotificationBundleProcessor.newJsonArray(jsonObject), true, showAsAlert);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return notificationId;
    }

    static JSONArray bundleAsJsonArray(Bundle bundle) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)NotificationBundleProcessor.bundleAsJSONObject(bundle));
        return jsonArray;
    }

    static void saveNotification(Context context, Bundle bundle, boolean opened, int notificationId) {
        NotificationBundleProcessor.saveNotification(context, NotificationBundleProcessor.bundleAsJSONObject(bundle), opened, notificationId);
    }

    static void saveNotification(Context context, JSONObject jsonPayload, boolean opened, int notificationId) {
        try {
            JSONObject customJSON = new JSONObject(jsonPayload.optString("custom"));
            OneSignalDbHelper dbHelper = new OneSignalDbHelper(context);
            SQLiteDatabase writableDb = dbHelper.getWritableDatabase();
            NotificationBundleProcessor.deleteOldNotifications(writableDb);
            ContentValues values = new ContentValues();
            values.put("notification_id", customJSON.optString("i"));
            if (jsonPayload.has("grp")) {
                values.put("group_id", jsonPayload.optString("grp"));
            }
            values.put("opened", Integer.valueOf(opened ? 1 : 0));
            if (!opened) {
                values.put("android_notification_id", Integer.valueOf(notificationId));
            }
            if (jsonPayload.has("title")) {
                values.put("title", jsonPayload.optString("title"));
            }
            values.put("message", jsonPayload.optString("alert"));
            values.put("full_data", jsonPayload.toString());
            writableDb.insert("notification", null, values);
            if (!opened) {
                BadgeCountUpdater.update(writableDb, context);
            }
            writableDb.close();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static void deleteOldNotifications(SQLiteDatabase writableDb) {
        writableDb.delete("notification", "created_time < " + (System.currentTimeMillis() / 1000L - 2419200L), null);
    }

    static JSONObject bundleAsJSONObject(Bundle bundle) {
        JSONObject json = new JSONObject();
        Set keys = bundle.keySet();
        for (String key : keys) {
            try {
                json.put(key, bundle.get(key));
            }
            catch (JSONException e) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "bundleAsJSONObject error for key: " + key, e);
            }
        }
        return json;
    }

    static void prepareBundle(Bundle gcmBundle) {
        if (gcmBundle.containsKey("o")) {
            try {
                JSONObject customJSON = new JSONObject(gcmBundle.getString("custom"));
                JSONObject additionalDataJSON = customJSON.has("a") ? customJSON.getJSONObject("a") : new JSONObject();
                JSONArray buttons = new JSONArray(gcmBundle.getString("o"));
                gcmBundle.remove("o");
                for (int i = 0; i < buttons.length(); ++i) {
                    String buttonId;
                    JSONObject button = buttons.getJSONObject(i);
                    String buttonText = button.getString("n");
                    button.remove("n");
                    if (button.has("i")) {
                        buttonId = button.getString("i");
                        button.remove("i");
                    } else {
                        buttonId = buttonText;
                    }
                    button.put("id", (Object)buttonId);
                    button.put("text", (Object)buttonText);
                    if (!button.has("p")) continue;
                    button.put("icon", (Object)button.getString("p"));
                    button.remove("p");
                }
                additionalDataJSON.put("actionButtons", (Object)buttons);
                additionalDataJSON.put("actionSelected", (Object)DEFAULT_ACTION);
                if (!customJSON.has("a")) {
                    customJSON.put("a", (Object)additionalDataJSON);
                }
                gcmBundle.putString("custom", customJSON.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    static OSNotificationPayload OSNotificationPayloadFrom(JSONObject currentJsonPayload) {
        OSNotificationPayload notification = new OSNotificationPayload();
        try {
            JSONObject customJson = new JSONObject(currentJsonPayload.optString("custom"));
            notification.notificationId = customJson.optString("i");
            notification.rawPayload = currentJsonPayload.toString();
            notification.additionalData = customJson.optJSONObject("a");
            notification.launchUrl = customJson.optString("u", null);
            notification.body = currentJsonPayload.optString("alert", null);
            notification.title = currentJsonPayload.optString("title", null);
            notification.smallIcon = currentJsonPayload.optString("sicon", null);
            notification.bigPicture = currentJsonPayload.optString("bicon", null);
            notification.largeIcon = currentJsonPayload.optString("licon", null);
            notification.sound = currentJsonPayload.optString("sound", null);
            notification.groupKey = currentJsonPayload.optString("grp", null);
            notification.groupMessage = currentJsonPayload.optString("grp_msg", null);
            notification.smallIconAccentColor = currentJsonPayload.optString("bgac", null);
            notification.ledColor = currentJsonPayload.optString("ledc", null);
            String visibility = currentJsonPayload.optString("vis", null);
            if (visibility != null) {
                notification.lockScreenVisibility = Integer.parseInt(visibility);
            }
            notification.fromProjectNumber = currentJsonPayload.optString("from", null);
            try {
                NotificationBundleProcessor.setActionButtons(notification);
            }
            catch (Throwable t) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error assigning OSNotificationPayload.actionButtons values!", t);
            }
            try {
                NotificationBundleProcessor.setBackgroundImageLayout(notification, currentJsonPayload);
            }
            catch (Throwable t) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error assigning OSNotificationPayload.backgroundImageLayout values!", t);
            }
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error assigning OSNotificationPayload values!", t);
        }
        return notification;
    }

    private static void setActionButtons(OSNotificationPayload notification) throws Throwable {
        if (notification.additionalData != null && notification.additionalData.has("actionButtons")) {
            JSONArray jsonActionButtons = notification.additionalData.getJSONArray("actionButtons");
            notification.actionButtons = new ArrayList<OSNotificationPayload.ActionButton>();
            for (int i = 0; i < jsonActionButtons.length(); ++i) {
                JSONObject jsonActionButton = jsonActionButtons.getJSONObject(i);
                OSNotificationPayload.ActionButton actionButton = new OSNotificationPayload.ActionButton();
                actionButton.id = jsonActionButton.optString("id", null);
                actionButton.text = jsonActionButton.optString("text", null);
                actionButton.icon = jsonActionButton.optString("icon", null);
                notification.actionButtons.add(actionButton);
            }
            notification.additionalData.remove("actionSelected");
            notification.additionalData.remove("actionButtons");
        }
    }

    private static void setBackgroundImageLayout(OSNotificationPayload notification, JSONObject currentJsonPayload) throws Throwable {
        String jsonStrBgImage = currentJsonPayload.optString("bg_img", null);
        if (jsonStrBgImage != null) {
            JSONObject jsonBgImage = new JSONObject(jsonStrBgImage);
            notification.backgroundImageLayout = new OSNotificationPayload.BackgroundImageLayout();
            notification.backgroundImageLayout.image = jsonBgImage.optString("img");
            notification.backgroundImageLayout.titleTextColor = jsonBgImage.optString("tc");
            notification.backgroundImageLayout.bodyTextColor = jsonBgImage.optString("bc");
        }
    }

    static boolean processBundle(Context context, final Bundle bundle) {
        if (OneSignal.getNotificationIdFromGCMBundle(bundle) == null) {
            return true;
        }
        NotificationBundleProcessor.prepareBundle(bundle);
        Intent overrideIntent = NotificationExtenderService.getIntent(context);
        if (overrideIntent != null) {
            overrideIntent.putExtra("json_payload", NotificationBundleProcessor.bundleAsJSONObject(bundle).toString());
            WakefulBroadcastReceiver.startWakefulService((Context)context, (Intent)overrideIntent);
            return true;
        }
        boolean display = NotificationBundleProcessor.shouldDisplay(bundle.getString("alert") != null && !"".equals(bundle.getString("alert")));
        if (!display) {
            if (OneSignal.notValidOrDuplicated(context, NotificationBundleProcessor.bundleAsJSONObject(bundle))) {
                return true;
            }
            NotificationBundleProcessor.saveNotification(context, bundle, true, -1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    OneSignal.handleNotificationReceived(NotificationBundleProcessor.bundleAsJsonArray(bundle), false, false);
                }
            }).start();
        }
        return !display;
    }

    static boolean shouldDisplay(boolean hasBody) {
        boolean showAsAlert = OneSignal.getInAppAlertNotificationEnabled();
        boolean isActive = OneSignal.isAppActive();
        return hasBody && (OneSignal.getNotificationsWhenActiveEnabled() || showAsAlert || !isActive);
    }

    static JSONArray newJsonArray(JSONObject jsonObject) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)jsonObject);
        return jsonArray;
    }
}

