/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationServices;
import com.onesignal.AndroidSupportV4Compat;
import com.onesignal.GoogleApiClientCompatProxy;
import com.onesignal.OneSignal;
import com.onesignal.PermissionsActivity;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;

class LocationGMS {
    private static GoogleApiClientCompatProxy mGoogleApiClient;
    static String requestPermission;
    private static LocationHandler locationHandler;
    private static Thread fallbackFailThread;
    private static boolean locationCoarse;

    LocationGMS() {
    }

    static void getLocation(Context context, boolean promptLocation, LocationHandler handler) {
        block13: {
            locationHandler = handler;
            int locationCoarsePermission = -1;
            int locationFinePermission = AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION");
            if (locationFinePermission == -1) {
                locationCoarsePermission = AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_COARSE_LOCATION");
                locationCoarse = true;
            }
            if (Build.VERSION.SDK_INT < 23) {
                if (locationFinePermission != 0 && locationCoarsePermission != 0) {
                    handler.complete(null, null, null, null);
                    return;
                }
                LocationGMS.startGetLocation();
            } else if (locationFinePermission != 0) {
                try {
                    PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
                    List<String> permissionList = Arrays.asList(packageInfo.requestedPermissions);
                    if (permissionList.contains("android.permission.ACCESS_FINE_LOCATION")) {
                        requestPermission = "android.permission.ACCESS_FINE_LOCATION";
                    } else if (permissionList.contains("android.permission.ACCESS_COARSE_LOCATION") && locationCoarsePermission != 0) {
                        requestPermission = "android.permission.ACCESS_COARSE_LOCATION";
                    }
                    if (requestPermission != null && promptLocation) {
                        PermissionsActivity.startPrompt();
                        break block13;
                    }
                    if (locationCoarsePermission == 0) {
                        LocationGMS.startGetLocation();
                        break block13;
                    }
                    LocationGMS.fireFailedComplete();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                LocationGMS.startGetLocation();
            }
        }
    }

    static void startGetLocation() {
        try {
            LocationGMS.startFallBackThread();
            GoogleApiClientListener googleApiClientListener = new GoogleApiClientListener();
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(OneSignal.appContext).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)googleApiClientListener).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)googleApiClientListener).build();
            mGoogleApiClient = new GoogleApiClientCompatProxy(googleApiClient);
            mGoogleApiClient.connect();
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Location permission exists but there was an error initializing: ", t);
            LocationGMS.fireFailedComplete();
        }
    }

    private static void startFallBackThread() {
        fallbackFailThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(30000L);
                    OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Location permission exists but GoogleApiClient timedout. Maybe related to mismatch google-play aar versions.");
                    LocationGMS.fireFailedComplete();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        fallbackFailThread.start();
    }

    static void fireFailedComplete() {
        PermissionsActivity.answered = false;
        LocationGMS.fireComplete(null, null, null, null);
        if (mGoogleApiClient != null) {
            mGoogleApiClient.disconnect();
        }
    }

    private static void fireComplete(Double lat, Double log, Float accuracy, Integer type) {
        locationHandler.complete(lat, log, accuracy, type);
        if (fallbackFailThread != null && !Thread.currentThread().equals(fallbackFailThread)) {
            fallbackFailThread.interrupt();
        }
    }

    private static class GoogleApiClientListener
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private GoogleApiClientListener() {
        }

        public void onConnected(Bundle bundle) {
            PermissionsActivity.answered = false;
            Location location = LocationServices.FusedLocationApi.getLastLocation(mGoogleApiClient.realInstance());
            if (location != null) {
                location.getAccuracy();
                Double lat = new BigDecimal(location.getLatitude()).setScale(7, RoundingMode.HALF_UP).doubleValue();
                Double log = new BigDecimal(location.getLongitude()).setScale(7, RoundingMode.HALF_UP).doubleValue();
                LocationGMS.fireComplete(lat, log, Float.valueOf(location.getAccuracy()), locationCoarse ? 0 : 1);
            } else {
                LocationGMS.fireComplete(null, null, null, null);
            }
            mGoogleApiClient.disconnect();
        }

        public void onConnectionSuspended(int i) {
            LocationGMS.fireFailedComplete();
        }

        public void onConnectionFailed(ConnectionResult connectionResult) {
            LocationGMS.fireFailedComplete();
        }
    }

    static interface LocationHandler {
        public void complete(Double var1, Double var2, Float var3, Integer var4);
    }
}

