/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import com.onesignal.OneSignal;
import com.onesignal.shortcutbadger.ShortcutBadger;

class BadgeCountUpdater {
    BadgeCountUpdater() {
    }

    static void update(SQLiteDatabase readableDb, Context context) {
        boolean isEnabled = true;
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            String defaultStr = bundle.getString("com.onesignal.BadgeCount");
            isEnabled = !"DISABLE".equals(defaultStr);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "", t);
        }
        if (isEnabled) {
            Cursor cursor = readableDb.query("notification", null, "dismissed = 0 AND opened = 0 AND is_summary = 0 ", null, null, null, null);
            BadgeCountUpdater.updateCount(cursor.getCount(), context);
            cursor.close();
        }
    }

    private static void updateCount(int count, Context context) {
        ShortcutBadger.applyCount(context, count);
    }
}

