/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.app.Instrumentation;
import android.app.OnActivityPausedListener;
import com.onesignal.ActivityLifecycleHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class ActivityLifecycleListenerCompat {
    ActivityLifecycleListenerCompat() {
    }

    static void startListener() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object activityThread = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Field instrumentationField = activityThreadClass.getDeclaredField("mInstrumentation");
            instrumentationField.setAccessible(true);
            Instrumentation instrumentation = (Instrumentation)instrumentationField.get(activityThread);
            Instrumentation.ActivityMonitor allActivitiesMonitor = instrumentation.addMonitor((String)null, null, false);
            ActivityLifecycleListenerCompat.startMonitorThread(activityThreadClass, activityThread, allActivitiesMonitor);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void startMonitorThread(final Class activityThreadClass, final Object activityThread, final Instrumentation.ActivityMonitor allActivitiesMonitor) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OnActivityPausedListener pausedListener = new OnActivityPausedListener(){

                        @Override
                        public void onPaused(Activity activity) {
                            ActivityLifecycleHandler.onActivityPaused(activity);
                        }
                    };
                    Method registerOnActivityPausedListener = activityThreadClass.getMethod("registerOnActivityPausedListener", Activity.class, OnActivityPausedListener.class);
                    while (true) {
                        Activity currentActivity;
                        if ((currentActivity = allActivitiesMonitor.waitForActivity()).isFinishing()) {
                            continue;
                        }
                        ActivityLifecycleHandler.onActivityResumed(currentActivity);
                        registerOnActivityPausedListener.invoke(activityThread, currentActivity, pausedListener);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return;
                }
            }
        }).start();
    }
}

