/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.onesignal.OneSignal;

class ActivityLifecycleHandler {
    static Activity curActivity;
    static FocusHandlerThread focusHandlerThread;

    ActivityLifecycleHandler() {
    }

    static void onActivityCreated(Activity activity) {
        curActivity = activity;
        ActivityLifecycleHandler.logCurActivity();
        ActivityLifecycleHandler.handleFocus();
    }

    static void onActivityStarted(Activity activity) {
        curActivity = activity;
        ActivityLifecycleHandler.logCurActivity();
        ActivityLifecycleHandler.handleFocus();
    }

    static void onActivityResumed(Activity activity) {
        curActivity = activity;
        ActivityLifecycleHandler.logCurActivity();
        ActivityLifecycleHandler.handleFocus();
    }

    static void onActivityPaused(Activity activity) {
        if (activity == curActivity) {
            curActivity = null;
            ActivityLifecycleHandler.handleLostFocus();
        }
        ActivityLifecycleHandler.logCurActivity();
    }

    static void onActivityStopped(Activity activity) {
        if (activity == curActivity) {
            curActivity = null;
            ActivityLifecycleHandler.handleLostFocus();
        }
        ActivityLifecycleHandler.logCurActivity();
    }

    static void onActivityDestroyed(Activity activity) {
        if (activity == curActivity) {
            curActivity = null;
            ActivityLifecycleHandler.handleLostFocus();
        }
        ActivityLifecycleHandler.logCurActivity();
    }

    private static void logCurActivity() {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "curActivity is NOW: " + (curActivity != null ? curActivity.getClass().getName() : "null"));
    }

    private static void handleLostFocus() {
        focusHandlerThread.runRunnable(new AppFocusRunnable());
    }

    private static void handleFocus() {
        if (focusHandlerThread.hasBackgrounded()) {
            focusHandlerThread.resetBackgroundState();
            OneSignal.onAppFocus();
        } else {
            focusHandlerThread.stopScheduledRunnable();
        }
    }

    static {
        focusHandlerThread = new FocusHandlerThread();
    }

    private static class AppFocusRunnable
    implements Runnable {
        private boolean backgrounded;
        private boolean completed;

        private AppFocusRunnable() {
        }

        @Override
        public void run() {
            if (curActivity != null) {
                return;
            }
            this.backgrounded = true;
            OneSignal.onAppLostFocus(false);
            this.completed = true;
        }
    }

    static class FocusHandlerThread
    extends HandlerThread {
        Handler mHandler = null;
        private AppFocusRunnable appFocusRunnable;

        FocusHandlerThread() {
            super("FocusHandlerThread");
            this.start();
            this.mHandler = new Handler(this.getLooper());
        }

        Looper getHandlerLooper() {
            return this.mHandler.getLooper();
        }

        void resetBackgroundState() {
            if (this.appFocusRunnable != null) {
                this.appFocusRunnable.backgrounded = false;
            }
        }

        void stopScheduledRunnable() {
            this.mHandler.removeCallbacksAndMessages(null);
        }

        void runRunnable(AppFocusRunnable runnable) {
            if (this.appFocusRunnable != null && this.appFocusRunnable.backgrounded && !this.appFocusRunnable.completed) {
                return;
            }
            this.appFocusRunnable = runnable;
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler.postDelayed((Runnable)runnable, 2000L);
        }

        boolean hasBackgrounded() {
            if (this.appFocusRunnable != null) {
                return this.appFocusRunnable.backgrounded;
            }
            return false;
        }
    }
}

