/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import com.onesignal.OneSignal;
import java.lang.reflect.Method;
import org.json.JSONObject;

public class OneSignalUnityProxy
implements OneSignal.NotificationOpenedHandler {
    private String unitylistenerName;
    private static Method unitySendMessage;

    public OneSignalUnityProxy(String listenerName, String googleProjectNumber, String oneSignalAppId, int logLevel, int visualLogLevel) {
        this.unitylistenerName = listenerName;
        try {
            Class<?> unityPlayerClass = Class.forName("com.unity3d.player.UnityPlayer");
            unitySendMessage = unityPlayerClass.getMethod("UnitySendMessage", String.class, String.class, String.class);
            OneSignal.setLogLevel(logLevel, visualLogLevel);
            OneSignal.init((Activity)unityPlayerClass.getField("currentActivity").get(null), googleProjectNumber, oneSignalAppId, this);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void notificationOpened(String message, JSONObject additionalData, boolean isActive) {
        JSONObject outerObject = new JSONObject();
        try {
            outerObject.put("isActive", isActive);
            outerObject.put("alert", (Object)message);
            outerObject.put("custom", (Object)additionalData);
            unitySendMessage.invoke(null, this.unitylistenerName, "onPushNotificationReceived", outerObject.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void onPause() {
        OneSignal.onPaused();
    }

    public void onResume() {
        OneSignal.onResumed();
    }

    public void sendTag(String key, String value) {
        OneSignal.sendTag(key, value);
    }

    public void sendTags(String json) {
        OneSignal.sendTags(json);
    }

    public void getTags() {
        OneSignal.getTags(new OneSignal.GetTagsHandler(){

            @Override
            public void tagsAvailable(JSONObject tags) {
                try {
                    unitySendMessage.invoke(null, OneSignalUnityProxy.this.unitylistenerName, "onTagsReceived", tags.toString());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    public void deleteTag(String key) {
        OneSignal.deleteTag(key);
    }

    public void deleteTags(String json) {
        OneSignal.deleteTags(json);
    }

    public void idsAvailable() {
        OneSignal.idsAvailable(new OneSignal.IdsAvailableHandler(){

            @Override
            public void idsAvailable(String userId, String registrationId) {
                JSONObject jsonIds = new JSONObject();
                try {
                    jsonIds.put("userId", (Object)userId);
                    if (registrationId != null) {
                        jsonIds.put("pushToken", (Object)registrationId);
                    } else {
                        jsonIds.put("pushToken", (Object)"");
                    }
                    unitySendMessage.invoke(null, OneSignalUnityProxy.this.unitylistenerName, "onIdsAvailable", jsonIds.toString());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    public void enableSound(boolean enable) {
        OneSignal.enableSound(enable);
    }

    public void enableVibrate(boolean enable) {
        OneSignal.enableVibrate(enable);
    }
}

