/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.support.v4.app.NotificationManagerCompat;
import com.onesignal.GenerateNotification;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NotificationOpenedProcessor {
    private static Context activity;
    private static Intent intent;

    public static void processFromActivity(Activity inActivity, Intent inIntent) {
        if (inIntent.getBooleanExtra("action_button", false)) {
            NotificationManagerCompat.from((Context)inActivity).cancel(inIntent.getIntExtra("notificationId", 0));
        }
        NotificationOpenedProcessor.processIntent((Context)inActivity, inIntent);
    }

    static void processIntent(Context inActivity, Intent inIntent) {
        activity = inActivity;
        intent = inIntent;
        String summaryGroup = intent.getStringExtra("summary");
        boolean dismissed = intent.getBooleanExtra("dismissed", false);
        OneSignalDbHelper dbHelper = new OneSignalDbHelper(activity);
        SQLiteDatabase writableDb = dbHelper.getWritableDatabase();
        JSONArray dataArray = null;
        if (!dismissed) {
            try {
                dataArray = NotificationBundleProcessor.newJsonArray(new JSONObject(intent.getStringExtra("data")));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (!dismissed && summaryGroup != null) {
            NotificationOpenedProcessor.addChildNotifications(dataArray, summaryGroup, writableDb);
        }
        NotificationOpenedProcessor.markNotificationsConsumed(writableDb);
        if (summaryGroup == null && intent.getStringExtra("grp") != null) {
            NotificationOpenedProcessor.updateSummaryNotification(writableDb);
        }
        writableDb.close();
        if (!dismissed) {
            OneSignal.handleNotificationOpened(activity, dataArray);
        }
    }

    private static void addChildNotifications(JSONArray dataArray, String summaryGroup, SQLiteDatabase writableDb) {
        String[] retColumn = new String[]{"full_data"};
        String[] whereArgs = new String[]{summaryGroup};
        Cursor cursor = writableDb.query("notification", retColumn, "group_id = ? AND dismissed = 0 AND opened = 0 AND is_summary = 0", whereArgs, null, null, null);
        if (cursor.getCount() > 1) {
            cursor.moveToFirst();
            do {
                try {
                    String jsonStr = cursor.getString(cursor.getColumnIndex("full_data"));
                    dataArray.put((Object)new JSONObject(jsonStr));
                }
                catch (Throwable t) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Could not parse JSON of sub notification in group: " + summaryGroup);
                }
            } while (cursor.moveToNext());
        }
    }

    private static void markNotificationsConsumed(SQLiteDatabase writableDb) {
        String whereStr;
        String group = intent.getStringExtra("summary");
        String[] whereArgs = null;
        if (group != null) {
            whereStr = "group_id = ?";
            whereArgs = new String[]{group};
        } else {
            whereStr = "android_notification_id = " + intent.getIntExtra("notificationId", 0);
        }
        writableDb.update("notification", NotificationOpenedProcessor.newContentValuesWithConsumed(), whereStr, whereArgs);
    }

    private static void updateSummaryNotification(SQLiteDatabase writableDb) {
        String grpId = intent.getStringExtra("grp");
        Cursor cursor = writableDb.query("notification", new String[]{"android_notification_id"}, "group_id = ? AND dismissed = 0 AND opened = 0 AND is_summary = 0", new String[]{grpId}, null, null, null);
        if (cursor.getCount() == 0) {
            writableDb.update("notification", NotificationOpenedProcessor.newContentValuesWithConsumed(), "group_id = ?", new String[]{grpId});
        } else {
            try {
                GenerateNotification.createSummaryNotification(activity, true, new JSONObject("{\"grp\": \"" + grpId + "\"}"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    private static ContentValues newContentValuesWithConsumed() {
        ContentValues values = new ContentValues();
        boolean dismissed = intent.getBooleanExtra("dismissed", false);
        if (dismissed) {
            values.put("dismissed", Integer.valueOf(1));
        } else {
            values.put("opened", Integer.valueOf(1));
        }
        return values;
    }
}

