/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2.servlet;

import com.onelogin.saml2.http.HttpRequest;
import com.onelogin.saml2.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletUtils {
    public static HttpRequest makeHttpRequest(HttpServletRequest req) {
        Map paramsAsArray = req.getParameterMap();
        HashMap paramsAsList = new HashMap();
        for (Map.Entry param : paramsAsArray.entrySet()) {
            paramsAsList.put(param.getKey(), Arrays.asList((Object[])param.getValue()));
        }
        return new HttpRequest(req.getRequestURL().toString(), paramsAsList);
    }

    public static String getSelfURLhost(HttpServletRequest request) {
        String hostUrl = "";
        int serverPort = request.getServerPort();
        hostUrl = serverPort == 80 || serverPort == 443 || serverPort == 0 ? String.format("%s://%s", request.getScheme(), request.getServerName()) : String.format("%s://%s:%s", request.getScheme(), request.getServerName(), serverPort);
        return hostUrl;
    }

    public static String getSelfHost(HttpServletRequest request) {
        return request.getServerName();
    }

    public static boolean isHTTPS(HttpServletRequest request) {
        return request.isSecure();
    }

    public static String getSelfURL(HttpServletRequest request) {
        String url = ServletUtils.getSelfURLhost(request);
        String requestUri = request.getRequestURI();
        String queryString = request.getQueryString();
        if (null != requestUri && !requestUri.isEmpty()) {
            url = url + requestUri;
        }
        if (null != queryString && !queryString.isEmpty()) {
            url = url + '?' + queryString;
        }
        return url;
    }

    public static String getSelfURLNoQuery(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }

    public static String getSelfRoutedURLNoQuery(HttpServletRequest request) {
        String url = ServletUtils.getSelfURLhost(request);
        String requestUri = request.getRequestURI();
        if (null != requestUri && !requestUri.isEmpty()) {
            url = url + requestUri;
        }
        return url;
    }

    public static void sendRedirect(HttpServletResponse response, String location, Map<String, String> parameters) throws IOException {
        String target = location;
        if (!parameters.isEmpty()) {
            boolean first = !location.contains("?");
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                if (first) {
                    target = target + "?";
                    first = false;
                } else {
                    target = target + "&";
                }
                target = target + parameter.getKey();
                if (parameter.getValue().isEmpty()) continue;
                target = target + "=" + Util.urlEncoder((String)parameter.getValue());
            }
        }
        response.sendRedirect(target);
    }

    public static void sendRedirect(HttpServletResponse response, String location) throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        ServletUtils.sendRedirect(response, location, parameters);
    }
}

