/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2.util;

import com.onelogin.saml2.exception.XMLEntityException;
import com.onelogin.saml2.util.Constants;
import com.onelogin.saml2.util.SchemaFactory;
import com.onelogin.saml2.util.XMLErrorAccumulatorHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Util {
    private static final Logger LOGGER = LoggerFactory.getLogger(Util.class);
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter DATE_TIME_FORMAT_MILLS = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(DateTimeZone.UTC);

    public static Document loadXML(String xml) {
        try {
            if (xml.contains("<!ENTITY")) {
                throw new XMLEntityException("Detected use of ENTITY in XML, disabled to prevent XXE/XEE attacks");
            }
            return Util.convertStringToDocument(xml);
        }
        catch (XMLEntityException e) {
            LOGGER.debug("Load XML error due XMLEntityException.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.debug("Load XML error: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static NodeList query(Document dom, String query, Node context) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                String result = null;
                if (prefix.equals("samlp") || prefix.equals("samlp2")) {
                    result = Constants.NS_SAMLP;
                } else if (prefix.equals("saml") || prefix.equals("saml2")) {
                    result = Constants.NS_SAML;
                } else if (prefix.equals("ds")) {
                    result = Constants.NS_DS;
                } else if (prefix.equals("xenc")) {
                    result = Constants.NS_XENC;
                } else if (prefix.equals("md")) {
                    result = Constants.NS_MD;
                }
                return result;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return null;
            }

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }
        });
        NodeList nodeList = context == null ? (NodeList)xpath.evaluate(query, dom, XPathConstants.NODESET) : (NodeList)xpath.evaluate(query, context, XPathConstants.NODESET);
        return nodeList;
    }

    public static NodeList query(Document dom, String query) throws XPathExpressionException {
        return Util.query(dom, query, null);
    }

    public static boolean validateXML(Document xmlDocument, URL schemaUrl) throws Exception {
        try {
            if (xmlDocument == null) {
                throw new IllegalArgumentException("xmlDocument was null");
            }
            Schema schema = SchemaFactory.loadFromUrl(schemaUrl);
            Validator validator = schema.newValidator();
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            XMLErrorAccumulatorHandler errorAcumulator = new XMLErrorAccumulatorHandler();
            validator.setErrorHandler(errorAcumulator);
            DOMSource xmlSource = new DOMSource(xmlDocument);
            validator.validate(xmlSource);
            return !errorAcumulator.hasError();
        }
        catch (Exception e) {
            LOGGER.debug("Error executing validateXML: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static Document convertStringToDocument(String xmlStr) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
        docfactory.setNamespaceAware(true);
        docfactory.setExpandEntityReferences(false);
        docfactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        try {
            docfactory.setAttribute("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            docfactory.setAttribute("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            docfactory.setAttribute("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            docfactory.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            docfactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            docfactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", Boolean.FALSE);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            docfactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Throwable t) {
            // empty catch block
        }
        DocumentBuilder builder = docfactory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xmlStr)));
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            XPathExpression expr = xpath.compile("//*[@ID]");
            NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element elem = (Element)nodeList.item(i);
                Attr attr = (Attr)elem.getAttributes().getNamedItem("ID");
                elem.setIdAttributeNode(attr, true);
            }
        }
        catch (XPathExpressionException e) {
            return null;
        }
        return doc;
    }

    public static String convertDocumentToString(Document doc, Boolean c14n) {
        Init.init();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (c14n.booleanValue()) {
            XMLUtils.outputDOMc14nWithComments((Node)doc, (OutputStream)baos);
        } else {
            XMLUtils.outputDOM((Node)doc, (OutputStream)baos);
        }
        return baos.toString();
    }

    public static String convertDocumentToString(Document doc) {
        return Util.convertDocumentToString(doc, false);
    }

    public static String formatCert(String cert, Boolean heads) {
        String x509cert = "";
        if (cert != null && !StringUtils.isEmpty((CharSequence)(x509cert = cert.replace("\\x0D", "").replace("\r", "").replace("\n", "").replace(" ", "")))) {
            x509cert = x509cert.replace("-----BEGINCERTIFICATE-----", "").replace("-----ENDCERTIFICATE-----", "");
            if (heads.booleanValue()) {
                x509cert = "-----BEGIN CERTIFICATE-----\n" + Util.chunkString(x509cert, 64) + "-----END CERTIFICATE-----";
            }
        }
        return x509cert;
    }

    public static String formatPrivateKey(String key, boolean heads) {
        String xKey = "";
        if (key != null && !StringUtils.isEmpty((CharSequence)(xKey = key.replace("\\x0D", "").replace("\r", "").replace("\n", "").replace(" ", "")))) {
            if (xKey.startsWith("-----BEGINPRIVATEKEY-----")) {
                xKey = xKey.replace("-----BEGINPRIVATEKEY-----", "").replace("-----ENDPRIVATEKEY-----", "");
                if (heads) {
                    xKey = "-----BEGIN PRIVATE KEY-----\n" + Util.chunkString(xKey, 64) + "-----END PRIVATE KEY-----";
                }
            } else {
                xKey = xKey.replace("-----BEGINRSAPRIVATEKEY-----", "").replace("-----ENDRSAPRIVATEKEY-----", "");
                if (heads) {
                    xKey = "-----BEGIN RSA PRIVATE KEY-----\n" + Util.chunkString(xKey, 64) + "-----END RSA PRIVATE KEY-----";
                }
            }
        }
        return xKey;
    }

    private static String chunkString(String str, int chunkSize) {
        String newStr = "";
        int stringLength = str.length();
        for (int i = 0; i < stringLength; i += chunkSize) {
            if (i + chunkSize > stringLength) {
                chunkSize = stringLength - i;
            }
            newStr = newStr + str.substring(i, chunkSize + i) + '\n';
        }
        return newStr;
    }

    public static X509Certificate loadCert(String certString) throws CertificateException, UnsupportedEncodingException {
        X509Certificate cert;
        certString = Util.formatCert(certString, true);
        try {
            cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certString.getBytes("utf-8")));
        }
        catch (IllegalArgumentException e) {
            cert = null;
        }
        return cert;
    }

    public static PrivateKey loadPrivateKey(String keyString) throws GeneralSecurityException, IOException {
        Init.init();
        keyString = Util.formatPrivateKey(keyString, false);
        keyString = Util.chunkString(keyString, 64);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PrivateKey privKey = null;
        try {
            byte[] encoded = Base64.decodeBase64((String)keyString);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
            privKey = kf.generatePrivate(keySpec);
        }
        catch (Exception e) {
            LOGGER.debug("Private Key not loaded: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        return privKey;
    }

    public static String calculateX509Fingerprint(X509Certificate x509cert, String alg) {
        String fingerprint = "";
        try {
            byte[] dataBytes = x509cert.getEncoded();
            if (alg == null || alg.isEmpty() || alg.equals("SHA-1") || alg.equals("sha1")) {
                fingerprint = DigestUtils.sha1Hex((byte[])dataBytes);
            } else if (alg.equals("SHA-256") || alg.equals("sha256")) {
                fingerprint = DigestUtils.sha256Hex((byte[])dataBytes);
            } else if (alg.equals("SHA-384") || alg.equals("sha384")) {
                fingerprint = DigestUtils.sha384Hex((byte[])dataBytes);
            } else if (alg.equals("SHA-512") || alg.equals("sha512")) {
                fingerprint = DigestUtils.sha512Hex((byte[])dataBytes);
            } else {
                LOGGER.debug("Error executing calculateX509Fingerprint. alg " + alg + " not supported");
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error executing calculateX509Fingerprint: " + e.getMessage(), (Throwable)e);
        }
        return fingerprint.toLowerCase();
    }

    public static String calculateX509Fingerprint(X509Certificate x509cert) {
        return Util.calculateX509Fingerprint(x509cert, "SHA-1");
    }

    public static String convertToPem(X509Certificate certificate) {
        String pemCert = "";
        try {
            Base64 encoder = new Base64(64);
            String cert_begin = "-----BEGIN CERTIFICATE-----\n";
            String end_cert = "-----END CERTIFICATE-----";
            byte[] derCert = certificate.getEncoded();
            String pemCertPre = new String(encoder.encode(derCert));
            pemCert = cert_begin + pemCertPre + end_cert;
        }
        catch (Exception e) {
            LOGGER.debug("Error converting certificate on PEM format: " + e.getMessage(), (Throwable)e);
        }
        return pemCert;
    }

    public static void sendRedirect(HttpServletResponse response, String location, Map<String, String> parameters) throws IOException {
        String target = location;
        if (!parameters.isEmpty()) {
            Boolean first = true;
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                if (first.booleanValue()) {
                    target = target + "?";
                    first = false;
                } else {
                    target = target + "&";
                }
                target = target + parameter.getKey();
                if (parameter.getValue().isEmpty()) continue;
                target = target + "=" + Util.urlEncoder(parameter.getValue());
            }
        }
        response.sendRedirect(target);
    }

    public static void sendRedirect(HttpServletResponse response, String location) throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Util.sendRedirect(response, location, parameters);
    }

    public static String getSelfURLhost(HttpServletRequest request) {
        String hostUrl = "";
        int serverPort = request.getServerPort();
        hostUrl = serverPort == 80 || serverPort == 443 || serverPort == 0 ? String.format("%s://%s", request.getScheme(), request.getServerName()) : String.format("%s://%s:%s", request.getScheme(), request.getServerName(), serverPort);
        return hostUrl;
    }

    public static String getSelfHost(HttpServletRequest request) {
        return request.getServerName();
    }

    public static boolean isHTTPS(HttpServletRequest request) {
        return request.isSecure();
    }

    public static String getSelfURL(HttpServletRequest request) {
        String url = Util.getSelfURLhost(request);
        String requestUri = request.getRequestURI();
        String queryString = request.getQueryString();
        if (null != requestUri && !requestUri.isEmpty()) {
            url = url + requestUri;
        }
        if (null != queryString && !queryString.isEmpty()) {
            url = url + '?' + queryString;
        }
        return url;
    }

    public static String getSelfURLNoQuery(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }

    public static String getSelfRoutedURLNoQuery(HttpServletRequest request) {
        String url = Util.getSelfURLhost(request);
        String requestUri = request.getRequestURI();
        if (null != requestUri && !requestUri.isEmpty()) {
            url = url + requestUri;
        }
        return url;
    }

    public static Path loadResource(String path) throws URISyntaxException, FileNotFoundException {
        URL myTestURL = ClassLoader.getSystemResource(path);
        if (myTestURL == null) {
            throw new FileNotFoundException(path);
        }
        return Paths.get(myTestURL.toURI());
    }

    public static String getFileAsString(String relativeResourcePath) throws URISyntaxException, IOException {
        Path filepath = Util.loadResource(relativeResourcePath);
        String fileAsString = new String(Files.readAllBytes(filepath));
        return fileAsString;
    }

    public static String base64decodedInflated(String input) {
        byte[] decoded = Base64.decodeBase64((String)input);
        try {
            Inflater decompresser = new Inflater(true);
            decompresser.setInput(decoded);
            byte[] result = new byte[2048];
            int resultLength = decompresser.inflate(result);
            decompresser.end();
            String inflated = new String(result, 0, resultLength, "UTF-8");
            return inflated;
        }
        catch (Exception e) {
            return new String(decoded);
        }
    }

    public static String deflatedBase64encoded(String input) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(8, true);
        DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)bytesOut, deflater);
        deflaterStream.write(input.getBytes(Charset.forName("UTF-8")));
        deflaterStream.finish();
        return new String(Base64.encodeBase64((byte[])bytesOut.toByteArray()));
    }

    public static String base64encoder(byte[] input) {
        return new String(Base64.encodeBase64((byte[])input));
    }

    public static String base64encoder(String input) {
        return Util.base64encoder(input.getBytes());
    }

    public static byte[] base64decoder(byte[] input) {
        return Base64.decodeBase64((byte[])input);
    }

    public static byte[] base64decoder(String input) {
        return Util.base64decoder(input.getBytes());
    }

    public static String urlEncoder(String input) {
        if (input != null) {
            try {
                return URLEncoder.encode(input, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("URL encoder error.", (Throwable)e);
                throw new IllegalArgumentException();
            }
        }
        return null;
    }

    public static String urlDecoder(String input) {
        if (input != null) {
            try {
                return URLDecoder.decode(input, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("URL decoder error.", (Throwable)e);
                throw new IllegalArgumentException();
            }
        }
        return null;
    }

    public static byte[] sign(String text, PrivateKey key, String signAlgorithm) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Init.init();
        if (signAlgorithm == null) {
            signAlgorithm = Constants.RSA_SHA1;
        }
        Signature instance = Signature.getInstance(Util.signatureAlgConversion(signAlgorithm));
        instance.initSign(key);
        instance.update(text.getBytes());
        byte[] signature = instance.sign();
        return signature;
    }

    public static String signatureAlgConversion(String sign) {
        String convertedSignatureAlg = "";
        convertedSignatureAlg = sign == null ? "SHA1withRSA" : (sign.equals(Constants.DSA_SHA1) ? "SHA1withDSA" : (sign.equals(Constants.RSA_SHA256) ? "SHA256withRSA" : (sign.equals(Constants.RSA_SHA384) ? "SHA384withRSA" : (sign.equals(Constants.RSA_SHA512) ? "SHA512withRSA" : "SHA1withRSA"))));
        return convertedSignatureAlg;
    }

    public static Boolean validateSign(Document doc, X509Certificate cert, String fingerprint, String alg) {
        try {
            NodeList signNodesToValidate = Util.query(doc, "/samlp:Response/ds:Signature");
            if (signNodesToValidate.getLength() == 0) {
                signNodesToValidate = Util.query(doc, "/samlp:Response/saml:Assertion/ds:Signature");
            }
            if (signNodesToValidate.getLength() == 1) {
                return Util.validateSignNode(signNodesToValidate.item(0), cert, fingerprint, alg);
            }
        }
        catch (XPathExpressionException e) {
            // empty catch block
        }
        return false;
    }

    public static Boolean validateMetadataSign(Document doc, X509Certificate cert, String fingerprint, String alg) {
        try {
            NodeList signNodesToValidate = Util.query(doc, "/md:EntitiesDescriptor/ds:Signature");
            if (signNodesToValidate.getLength() == 0 && (signNodesToValidate = Util.query(doc, "/md:EntityDescriptor/ds:Signature")).getLength() == 0) {
                signNodesToValidate = Util.query(doc, "/md:EntityDescriptor/md:SPSSODescriptor/ds:Signature|/md:EntityDescriptor/IDPSSODescriptor/ds:Signature");
            }
            if (signNodesToValidate.getLength() > 0) {
                for (int i = 0; i < signNodesToValidate.getLength(); ++i) {
                    Node signNode = signNodesToValidate.item(0);
                    if (Util.validateSignNode(signNode, cert, fingerprint, alg).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        }
        catch (XPathExpressionException e) {
            String er = e.getMessage();
        }
        return false;
    }

    public static Boolean validateSignNode(Node signNode, X509Certificate cert, String fingerprint, String alg) {
        Boolean res = false;
        try {
            Init.init();
            Element sigElement = (Element)signNode;
            XMLSignature signature = new XMLSignature(sigElement, "");
            if (cert != null) {
                res = signature.checkSignatureValue(cert);
            } else {
                X509Certificate providedCert;
                KeyInfo keyInfo = signature.getKeyInfo();
                if (keyInfo != null && keyInfo.containsX509Data() && fingerprint.equals(Util.calculateX509Fingerprint(providedCert = keyInfo.getX509Certificate(), alg))) {
                    res = signature.checkSignatureValue(providedCert);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error executing validateSignNode: " + e.getMessage(), (Throwable)e);
        }
        return res;
    }

    public static void decryptElement(Element encryptedDataElement, PrivateKey inputKey) {
        try {
            Init.init();
            XMLCipher xmlCipher = XMLCipher.getInstance();
            xmlCipher.init(2, null);
            xmlCipher.setKEK((Key)inputKey);
            xmlCipher.doFinal(encryptedDataElement.getOwnerDocument(), encryptedDataElement, false);
        }
        catch (Exception e) {
            LOGGER.debug("Error executing decryption: " + e.getMessage(), (Throwable)e);
        }
    }

    public static Document copyDocument(Document source) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Element originalRoot = source.getDocumentElement();
        Document copiedDocument = db.newDocument();
        Node copiedRoot = copiedDocument.importNode(originalRoot, true);
        copiedDocument.appendChild(copiedRoot);
        return copiedDocument;
    }

    public static String addSign(Document document, PrivateKey key, X509Certificate certificate, String signAlgorithm) throws XMLSecurityException, XPathExpressionException {
        String id;
        Init.init();
        if (document == null) {
            throw new IllegalArgumentException("Provided document was null");
        }
        if (document.getDocumentElement() == null) {
            throw new IllegalArgumentException("The Xml Document has no root element.");
        }
        if (key == null) {
            throw new IllegalArgumentException("Provided key was null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("Provided certificate was null");
        }
        if (signAlgorithm == null || signAlgorithm.isEmpty()) {
            signAlgorithm = Constants.RSA_SHA1;
        }
        String c14nMethod = Constants.C14N_WC;
        XMLSignature sig = new XMLSignature(document, null, signAlgorithm, c14nMethod);
        Element root = document.getDocumentElement();
        document.setXmlStandalone(false);
        NodeList issuerNodes = Util.query(document, "//saml:Issuer", null);
        if (issuerNodes.getLength() > 0) {
            Node issuer = issuerNodes.item(0);
            root.insertBefore(sig.getElement(), issuer.getNextSibling());
        } else {
            root.insertBefore(sig.getElement(), root.getFirstChild());
        }
        String reference = id = root.getAttribute("ID");
        if (!id.isEmpty()) {
            root.setIdAttributeNS(null, "ID", true);
            reference = "#" + id;
        }
        Transforms transforms = new Transforms(document);
        transforms.addTransform(Constants.ENVSIG);
        transforms.addTransform(c14nMethod);
        sig.addDocument(reference, transforms, Constants.SHA1);
        sig.addKeyInfo(certificate);
        sig.sign((Key)key);
        return Util.convertDocumentToString(document, true);
    }

    public static String addSign(Node node, PrivateKey key, X509Certificate certificate, String signAlgorithm) throws ParserConfigurationException, XPathExpressionException, XMLSecurityException {
        if (node == null) {
            throw new IllegalArgumentException("Provided node was null");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().newDocument();
        Node newNode = doc.importNode(node, true);
        doc.appendChild(newNode);
        return Util.addSign(doc, key, certificate, signAlgorithm);
    }

    public static Boolean validateBinarySignature(String signedQuery, byte[] signature, X509Certificate cert, String signAlg) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        Boolean valid = false;
        try {
            Init.init();
            String convertedSigAlg = Util.signatureAlgConversion(signAlg);
            Signature sig = Signature.getInstance(convertedSigAlg);
            sig.initVerify(cert.getPublicKey());
            sig.update(signedQuery.getBytes());
            valid = sig.verify(signature);
        }
        catch (Exception e) {
            LOGGER.debug("Error executing validateSign: " + e.getMessage(), (Throwable)e);
        }
        return valid;
    }

    public static String generateNameId(String value, String spnq, String format, X509Certificate cert) {
        String res = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().newDocument();
            Element nameId = doc.createElement("saml:NameID");
            if (spnq != null && !spnq.isEmpty()) {
                nameId.setAttribute("SPNameQualifier", spnq);
            }
            if (format != null && !format.isEmpty()) {
                nameId.setAttribute("Format", format);
            }
            nameId.appendChild(doc.createTextNode(value));
            doc.appendChild(nameId);
            if (cert != null) {
                SecretKey symmetricKey = Util.generateSymmetricKey();
                XMLCipher xmlCipher = XMLCipher.getInstance((String)Constants.AES128_CBC);
                xmlCipher.init(1, (Key)symmetricKey);
                XMLCipher keyCipher = XMLCipher.getInstance((String)Constants.RSA_1_5);
                keyCipher.init(3, (Key)cert.getPublicKey());
                EncryptedKey encryptedKey = keyCipher.encryptKey(doc, (Key)symmetricKey);
                EncryptedData encryptedData = xmlCipher.getEncryptedData();
                KeyInfo keyInfo = new KeyInfo(doc);
                keyInfo.add(encryptedKey);
                encryptedData.setKeyInfo(keyInfo);
                xmlCipher.doFinal(doc, nameId, false);
                res = "<saml:EncryptedID>" + Util.convertDocumentToString(doc) + "</saml:EncryptedID>";
            } else {
                res = Util.convertDocumentToString(doc);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error executing generateNameId: " + e.getMessage(), (Throwable)e);
        }
        return res;
    }

    public static String generateNameId(String value, String spnq, String format) {
        return Util.generateNameId(value, spnq, format, null);
    }

    private static SecretKey generateSymmetricKey() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(128);
        return keyGenerator.generateKey();
    }

    public static String generateUniqueID() {
        String uniqueIdSha1 = "";
        String uniqueId = "";
        try {
            Random r = new Random();
            Integer n = r.nextInt();
            String id = Util.uniqid(n.toString(), true);
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(id.getBytes());
            uniqueIdSha1 = new BigInteger(1, crypt.digest()).toString(16);
            uniqueId = "ONELOGIN_" + uniqueIdSha1;
        }
        catch (Exception e) {
            LOGGER.error("Error executing generateUniqueID: " + e.getMessage(), (Throwable)e);
        }
        return uniqueId;
    }

    public static String uniqid(String prefix, Boolean more_entropy) {
        if (prefix != null && StringUtils.isEmpty((CharSequence)prefix)) {
            prefix = "";
        }
        if (!more_entropy.booleanValue()) {
            return (prefix + UUID.randomUUID().toString()).substring(0, 13);
        }
        return (prefix + UUID.randomUUID().toString() + UUID.randomUUID().toString()).substring(0, 23);
    }

    public static long parseDuration(String duration) throws IllegalArgumentException {
        TimeZone timeZone = DateTimeZone.UTC.toTimeZone();
        return Util.parseDuration(duration, Calendar.getInstance(timeZone).getTimeInMillis() / 1000L);
    }

    public static long parseDuration(String durationString, long timestamp) throws IllegalArgumentException {
        boolean haveMinus = false;
        if (durationString.startsWith("-")) {
            durationString = durationString.substring(1);
            haveMinus = true;
        }
        PeriodFormatter periodFormatter = ISOPeriodFormat.standard().withLocale(new Locale("UTC"));
        Period period = periodFormatter.parsePeriod(durationString);
        DateTime dt = new DateTime(timestamp * 1000L, DateTimeZone.UTC);
        DateTime result = null;
        result = haveMinus ? dt.minus((ReadablePeriod)period) : dt.plus((ReadablePeriod)period);
        return result.getMillis() / 1000L;
    }

    public static Long getCurrentTimeStamp() {
        DateTime currentDate = new DateTime(DateTimeZone.UTC);
        return currentDate.getMillis() / 1000L;
    }

    public static long getExpireTime(String cacheDuration, String validUntil) {
        long expireTime = 0L;
        try {
            if (cacheDuration != null && !StringUtils.isEmpty((CharSequence)cacheDuration)) {
                expireTime = Util.parseDuration(cacheDuration);
            }
            if (validUntil != null && !StringUtils.isEmpty((CharSequence)validUntil)) {
                DateTime dt = Util.parseDateTime(validUntil);
                long validUntilTimeInt = dt.getMillis() / 1000L;
                if (expireTime == 0L || expireTime > validUntilTimeInt) {
                    expireTime = validUntilTimeInt;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error executing getExpireTime: " + e.getMessage(), (Throwable)e);
        }
        return expireTime;
    }

    public static long getExpireTime(String cacheDuration, long validUntil) {
        long expireTime = 0L;
        try {
            if (cacheDuration != null && !StringUtils.isEmpty((CharSequence)cacheDuration)) {
                expireTime = Util.parseDuration(cacheDuration);
            }
            if (expireTime == 0L || expireTime > validUntil) {
                expireTime = validUntil;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error executing getExpireTime: " + e.getMessage(), (Throwable)e);
        }
        return expireTime;
    }

    public static String formatDateTime(long timeInMillis) {
        return DATE_TIME_FORMAT.print(timeInMillis);
    }

    public static String formatDateTime(long timeInMillis, boolean millis) {
        if (millis) {
            return DATE_TIME_FORMAT_MILLS.print(timeInMillis);
        }
        return Util.formatDateTime(timeInMillis);
    }

    public static DateTime parseDateTime(String dateTime) {
        DateTime parsedData = null;
        try {
            parsedData = DATE_TIME_FORMAT.parseDateTime(dateTime);
        }
        catch (Exception e) {
            return DATE_TIME_FORMAT_MILLS.parseDateTime(dateTime);
        }
        return parsedData;
    }
}

