/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2.authn;

import com.onelogin.saml2.model.SamlResponseStatus;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.util.Constants;
import com.onelogin.saml2.util.SchemaFactory;
import com.onelogin.saml2.util.Util;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.xpath.XPathExpressionException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SamlResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlResponse.class);
    private final Saml2Settings settings;
    private String samlResponseString;
    private Document samlResponseDocument;
    private Document decryptedDocument;
    private String currentUrl;
    private Boolean encrypted = false;
    private String error;

    public SamlResponse(Saml2Settings settings, HttpServletRequest request) throws Exception {
        this.settings = settings;
        if (request != null) {
            this.currentUrl = request.getRequestURL().toString();
            this.loadXmlFromBase64(request.getParameter("SAMLResponse"));
        }
    }

    public void loadXmlFromBase64(String responseStr) throws Exception {
        this.samlResponseString = new String(Util.base64decoder(responseStr));
        this.samlResponseDocument = Util.loadXML(this.samlResponseString);
        if (this.samlResponseDocument == null) {
            throw new IllegalArgumentException("SAML Response could not be processed");
        }
        NodeList encryptedAssertionNodes = this.samlResponseDocument.getElementsByTagNameNS(Constants.NS_SAML, "EncryptedAssertion");
        if (encryptedAssertionNodes.getLength() != 0) {
            this.decryptedDocument = Util.copyDocument(this.samlResponseDocument);
            this.encrypted = true;
            this.decryptedDocument = this.decryptAssertion(this.decryptedDocument);
        }
    }

    public boolean isValid(String requestId) {
        this.error = null;
        try {
            if (this.samlResponseDocument == null) {
                throw new Exception("SAML Response is not loaded");
            }
            if (this.currentUrl == null || this.currentUrl.isEmpty()) {
                throw new Exception("The URL of the current host was not established");
            }
            Element rootElement = this.samlResponseDocument.getDocumentElement();
            rootElement.normalize();
            if (!rootElement.getAttribute("Version").equals("2.0")) {
                throw new Exception("Unsupported SAML Version.");
            }
            if (!rootElement.hasAttribute("ID")) {
                throw new Exception("Missing ID attribute on SAML Response.");
            }
            this.checkStatus();
            if (!this.validateNumAssertions().booleanValue()) {
                throw new IllegalArgumentException("SAML Response must contain 1 Assertion.");
            }
            ArrayList<String> signedElements = this.processSignedElements();
            if (this.settings.isStrict()) {
                String destinationUrl;
                NodeList encryptedNameIdNodes;
                if (this.settings.getWantXMLValidation().booleanValue()) {
                    if (!Util.validateXML(this.samlResponseDocument, SchemaFactory.SAML_SCHEMA_PROTOCOL_2_0)) {
                        throw new Exception("Invalid SAML Response. Not match the saml-schema-protocol-2.0.xsd");
                    }
                    if (this.encrypted.booleanValue() && !Util.validateXML(this.decryptedDocument, SchemaFactory.SAML_SCHEMA_PROTOCOL_2_0)) {
                        throw new Exception("Invalid decrypted SAML Response. Not match the saml-schema-protocol-2.0.xsd");
                    }
                }
                String responseInResponseTo = rootElement.getAttribute("InResponseTo");
                if (requestId != null && !requestId.isEmpty() && rootElement.hasAttribute("InResponseTo") && !responseInResponseTo.equals(requestId)) {
                    throw new Exception("The InResponseTo of the Response: " + responseInResponseTo + ", does not match the ID of the AuthNRequest sent by the SP: " + requestId);
                }
                if (!this.encrypted.booleanValue() && this.settings.getWantAssertionsEncrypted().booleanValue()) {
                    throw new Exception("The assertion of the Response is not encrypted and the SP requires it");
                }
                if (this.settings.getWantNameIdEncrypted().booleanValue() && (encryptedNameIdNodes = this.queryAssertion("/saml:Subject/saml:EncryptedID/xenc:EncryptedData")).getLength() == 0) {
                    throw new Exception("The NameID of the Response is not encrypted and the SP requires it");
                }
                if (!this.validateTimestamps()) {
                    throw new Exception("Timing issues (please check your clock settings)");
                }
                NodeList encryptedAttributeNodes = this.queryAssertion("/saml:AttributeStatement/saml:EncryptedAttribute");
                if (encryptedAttributeNodes.getLength() > 0) {
                    throw new Exception("There is an EncryptedAttribute in the Response and this SP not support them");
                }
                if (rootElement.hasAttribute("Destination") && (destinationUrl = rootElement.getAttribute("Destination")) != null && !destinationUrl.isEmpty() && !destinationUrl.equals(this.currentUrl)) {
                    throw new Exception("The response was received at " + this.currentUrl + " instead of " + destinationUrl);
                }
                List<String> validAudiences = this.getAudiences();
                if (!validAudiences.isEmpty() && !validAudiences.contains(this.settings.getSpEntityId())) {
                    throw new Exception(this.settings.getSpEntityId() + " is not a valid audience for this Response");
                }
                List<String> issuers = this.getIssuers();
                for (int i = 0; i < issuers.size(); ++i) {
                    String issuer = issuers.get(i);
                    if (!issuer.isEmpty() && issuer.equals(this.settings.getIdpEntityId())) continue;
                    throw new Exception("Invalid issuer in the Assertion/Response");
                }
                DateTime sessionExpiration = this.getSessionNotOnOrAfter();
                if (sessionExpiration != null && (sessionExpiration.isEqualNow() || sessionExpiration.isBeforeNow())) {
                    throw new Exception("The attributes have expired, based on the SessionNotOnOrAfter of the AttributeStatement of this Response");
                }
                boolean validSubjectConfirmation = false;
                NodeList subjectConfirmationNodes = this.queryAssertion("/saml:Subject/saml:SubjectConfirmation");
                for (int i = 0; i < subjectConfirmationNodes.getLength(); ++i) {
                    Node scn = subjectConfirmationNodes.item(i);
                    Node method = scn.getAttributes().getNamedItem("Method");
                    if (method != null && !method.getNodeValue().equals(Constants.CM_BEARER)) continue;
                    NodeList subjectConfirmationDataNodes = scn.getChildNodes();
                    for (int c = 0; c < subjectConfirmationDataNodes.getLength(); ++c) {
                        DateTime nb;
                        Node notBefore;
                        DateTime noa;
                        Node notOnOrAfter;
                        Node inResponseTo;
                        Node recipient;
                        if (subjectConfirmationDataNodes.item(c).getLocalName() == null || !subjectConfirmationDataNodes.item(c).getLocalName().equals("SubjectConfirmationData") || (recipient = subjectConfirmationDataNodes.item(c).getAttributes().getNamedItem("Recipient")) != null && !recipient.getNodeValue().isEmpty() && !recipient.getNodeValue().equals(this.currentUrl) || (inResponseTo = subjectConfirmationDataNodes.item(c).getAttributes().getNamedItem("InResponseTo")) != null && !inResponseTo.getNodeValue().equals(responseInResponseTo) || (notOnOrAfter = subjectConfirmationDataNodes.item(c).getAttributes().getNamedItem("NotOnOrAfter")) != null && ((noa = Util.parseDateTime(notOnOrAfter.getNodeValue())).isEqualNow() || noa.isBeforeNow()) || (notBefore = subjectConfirmationDataNodes.item(c).getAttributes().getNamedItem("NotBefore")) != null && (nb = Util.parseDateTime(notBefore.getNodeValue())).isAfterNow()) continue;
                        validSubjectConfirmation = true;
                    }
                }
                if (!validSubjectConfirmation) {
                    throw new Exception("A valid SubjectConfirmation was not found on this Response");
                }
                if (this.settings.getWantAssertionsSigned().booleanValue() && !signedElements.contains("Assertion")) {
                    throw new Exception("The Assertion of the Response is not signed and the SP requires it");
                }
                if (this.settings.getWantMessagesSigned().booleanValue() && !signedElements.contains("Response")) {
                    throw new Exception("The Message of the Response is not signed and the SP requires it");
                }
            }
            if (signedElements.isEmpty()) {
                throw new Exception("No Signature found. SAML Response rejected");
            }
            X509Certificate cert = this.settings.getIdpx509cert();
            String fingerprint = this.settings.getIdpCertFingerprint();
            String alg = this.settings.getIdpCertFingerprintAlgorithm();
            Document documentToValidate = signedElements.contains("Response") ? this.samlResponseDocument : (this.encrypted != false ? this.decryptedDocument : this.samlResponseDocument);
            if (!Util.validateSign(documentToValidate, cert, fingerprint, alg).booleanValue()) {
                throw new Exception("Signature validation failed. SAML Response rejected");
            }
            LOGGER.debug("SAMLResponse validated --> " + this.samlResponseString);
            return true;
        }
        catch (Error | Exception e) {
            this.error = e.getMessage();
            LOGGER.debug("SAMLResponse invalid --> " + this.samlResponseString);
            LOGGER.error(this.error);
            return false;
        }
    }

    public boolean isValid() {
        return this.isValid(null);
    }

    public HashMap<String, String> getNameIdData() throws Exception {
        NodeList nameIdNodes;
        HashMap<String, String> nameIdData = new HashMap<String, String>();
        NodeList encryptedIDNodes = this.queryAssertion("/saml:Subject/saml:EncryptedID/xenc:EncryptedData");
        if (encryptedIDNodes.getLength() > 0) {
            Element encryptedData = (Element)encryptedIDNodes.item(0);
            PrivateKey key = this.settings.getSPkey();
            if (key == null) {
                throw new IllegalArgumentException("Key is required in order to decrypt the NameID");
            }
            Util.decryptElement(encryptedData, key);
            nameIdNodes = this.queryAssertion("/saml:Subject/saml:EncryptedID/saml:NameID|/saml:Subject/saml:NameID");
            if (nameIdNodes == null || nameIdNodes.getLength() == 0) {
                throw new Exception("Not able to decrypt the EncryptedID and get a NameID");
            }
        } else {
            nameIdNodes = this.queryAssertion("/saml:Subject/saml:NameID");
        }
        if (nameIdNodes != null && nameIdNodes.getLength() > 0) {
            Element nameIdElem = (Element)nameIdNodes.item(0);
            if (nameIdElem != null) {
                nameIdData.put("Value", nameIdElem.getTextContent());
                if (nameIdElem.hasAttribute("Format")) {
                    nameIdData.put("Format", nameIdElem.getAttribute("Format"));
                }
                if (nameIdElem.hasAttribute("SPNameQualifier")) {
                    nameIdData.put("SPNameQualifier", nameIdElem.getAttribute("SPNameQualifier"));
                }
                if (nameIdElem.hasAttribute("NameQualifier")) {
                    nameIdData.put("NameQualifier", nameIdElem.getAttribute("NameQualifier"));
                }
            }
        } else if (this.settings.getWantNameId().booleanValue()) {
            throw new Exception("No name id found in Document.");
        }
        return nameIdData;
    }

    public String getNameId() throws Exception {
        HashMap<String, String> nameIdData = this.getNameIdData();
        String nameID = null;
        if (!nameIdData.isEmpty()) {
            LOGGER.debug("SAMLResponse has NameID --> " + nameIdData.get("Value"));
            nameID = nameIdData.get("Value");
        }
        return nameID;
    }

    public HashMap<String, List<String>> getAttributes() throws XPathExpressionException {
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        NodeList nodes = this.queryAssertion("/saml:AttributeStatement/saml:Attribute");
        if (nodes.getLength() != 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                NamedNodeMap attrName = nodes.item(i).getAttributes();
                String attName = attrName.getNamedItem("Name").getNodeValue();
                NodeList childrens = nodes.item(i).getChildNodes();
                ArrayList<String> attrValues = new ArrayList<String>();
                for (int j = 0; j < childrens.getLength(); ++j) {
                    if (!"AttributeValue".equals(childrens.item(j).getLocalName())) continue;
                    attrValues.add(childrens.item(j).getTextContent());
                }
                attributes.put(attName, attrValues);
            }
            LOGGER.debug("SAMLResponse has attributes: " + attributes.toString());
        } else {
            LOGGER.debug("SAMLResponse has no attributes");
        }
        return attributes;
    }

    public void checkStatus() {
        SamlResponseStatus responseStatus = SamlResponse.getStatus(this.samlResponseDocument);
        if (!responseStatus.is(Constants.STATUS_SUCCESS)) {
            String statusExceptionMsg = "The status code of the Response was not Success, was " + responseStatus.getStatusCode();
            if (responseStatus.getStatusMessage() != null) {
                statusExceptionMsg = statusExceptionMsg + " -> " + responseStatus.getStatusMessage();
            }
            throw new IllegalArgumentException(statusExceptionMsg);
        }
    }

    public static SamlResponseStatus getStatus(Document dom) throws IllegalArgumentException {
        try {
            String statusExpr = "/samlp:Response/samlp:Status";
            NodeList statusEntry = Util.query(dom, statusExpr, null);
            if (statusEntry.getLength() == 0) {
                throw new IllegalArgumentException("Missing Status on response");
            }
            NodeList codeEntry = Util.query(dom, statusExpr + "/samlp:StatusCode", (Element)statusEntry.item(0));
            if (codeEntry.getLength() == 0) {
                throw new IllegalArgumentException("Missing Status Code on response");
            }
            String stausCode = codeEntry.item(0).getAttributes().getNamedItem("Value").getNodeValue();
            SamlResponseStatus status = new SamlResponseStatus(stausCode);
            NodeList messageEntry = Util.query(dom, statusExpr + "/samlp:StatusMessage", (Element)statusEntry.item(0));
            if (messageEntry.getLength() > 0) {
                status.setStatusMessage(messageEntry.item(0).getTextContent());
            }
            return status;
        }
        catch (XPathExpressionException e) {
            LOGGER.error("Unexpected error in query parser." + e.getMessage());
            throw new IllegalArgumentException();
        }
    }

    public List<String> getAudiences() throws XPathExpressionException {
        ArrayList<String> audiences = new ArrayList<String>();
        NodeList entries = this.queryAssertion("/saml:Conditions/saml:AudienceRestriction/saml:Audience");
        for (int i = 0; i < entries.getLength(); ++i) {
            String value;
            if (entries.item(i) == null || (value = entries.item(i).getTextContent()) == null || value.trim().isEmpty()) continue;
            audiences.add(value.trim());
        }
        return audiences;
    }

    public List<String> getIssuers() throws XPathExpressionException {
        NodeList assertionIssuer;
        String value;
        ArrayList<String> issuers = new ArrayList<String>();
        NodeList responseIssuer = Util.query(this.samlResponseDocument, "/samlp:Response/saml:Issuer");
        if (responseIssuer.getLength() == 1 && !issuers.contains(value = responseIssuer.item(0).getTextContent())) {
            issuers.add(value);
        }
        if ((assertionIssuer = this.queryAssertion("/saml:Issuer")).getLength() == 1 && !issuers.contains(value = assertionIssuer.item(0).getTextContent())) {
            issuers.add(value);
        }
        return issuers;
    }

    public DateTime getSessionNotOnOrAfter() throws XPathExpressionException {
        String notOnOrAfter = null;
        NodeList entries = this.queryAssertion("/saml:AuthnStatement[@SessionNotOnOrAfter]");
        if (entries.getLength() > 0) {
            notOnOrAfter = entries.item(0).getAttributes().getNamedItem("SessionNotOnOrAfter").getNodeValue();
            return Util.parseDateTime(notOnOrAfter);
        }
        return null;
    }

    public String getSessionIndex() throws XPathExpressionException {
        String sessionIndex = null;
        NodeList entries = this.queryAssertion("/saml:AuthnStatement[@SessionIndex]");
        if (entries.getLength() > 0) {
            sessionIndex = entries.item(0).getAttributes().getNamedItem("SessionIndex").getNodeValue();
        }
        return sessionIndex;
    }

    public Boolean validateNumAssertions() throws IllegalArgumentException {
        NodeList encryptedAssertionNodes = this.samlResponseDocument.getElementsByTagNameNS(Constants.NS_SAML, "EncryptedAssertion");
        NodeList assertionNodes = this.samlResponseDocument.getElementsByTagNameNS(Constants.NS_SAML, "Assertion");
        return assertionNodes.getLength() + encryptedAssertionNodes.getLength() == 1;
    }

    public ArrayList<String> processSignedElements() throws Exception {
        ArrayList<String> signedElements = new ArrayList<String>();
        ArrayList<String> verifiedSeis = new ArrayList<String>();
        ArrayList<String> verifiedIds = new ArrayList<String>();
        NodeList signNodes = this.query("//ds:Signature", null);
        for (int i = 0; i < signNodes.getLength(); ++i) {
            Node refNode;
            Node seiNode;
            Node signNode = signNodes.item(i);
            String signedElement = signNode.getParentNode().getLocalName();
            if (!signedElement.equals("Response") && !signedElement.equals("Assertion")) {
                throw new Exception("Invalid Signature Element " + signedElement + " SAML Response rejected");
            }
            Node idNode = signNode.getParentNode().getAttributes().getNamedItem("ID");
            if (idNode == null || idNode.getNodeValue() == null || idNode.getNodeValue().isEmpty()) {
                throw new Exception("Signed Element must contain an ID. SAML Response rejected");
            }
            String idValue = idNode.getNodeValue();
            if (verifiedIds.contains(idValue)) {
                throw new Exception("Duplicated ID. SAML Response rejected");
            }
            verifiedIds.add(idValue);
            NodeList refNodes = Util.query(null, ".//ds:Reference", signNode);
            if (refNodes.getLength() > 0 && (seiNode = (refNode = refNodes.item(0)).getAttributes().getNamedItem("URI")) != null && seiNode.getNodeValue() != null && !seiNode.getNodeValue().isEmpty()) {
                String sei = seiNode.getNodeValue().substring(1);
                if (!sei.equals(idValue)) {
                    throw new Exception("Found an invalid Signed Element. SAML Response rejected");
                }
                if (verifiedSeis.contains(sei)) {
                    throw new Exception("Duplicated Reference URI. SAML Response rejected");
                }
                verifiedSeis.add(sei);
            }
            signedElements.add(signedElement);
        }
        if (!signedElements.isEmpty() && !SamlResponse.validateSignedElements(signedElements)) {
            throw new Exception("Found an unexpected Signature Element. SAML Response rejected");
        }
        return signedElements;
    }

    public static boolean validateSignedElements(ArrayList<String> signedElements) {
        if (signedElements.size() > 2) {
            return false;
        }
        HashMap<String, Integer> occurrences = new HashMap<String, Integer>();
        for (String e : signedElements) {
            if (occurrences.containsKey(e)) {
                occurrences.put(e, (Integer)occurrences.get(e) + 1);
                continue;
            }
            occurrences.put(e, 1);
        }
        return !(occurrences.containsKey("Response") && (Integer)occurrences.get("Response") > 1 || occurrences.containsKey("Assertion") && (Integer)occurrences.get("Assertion") > 1) && (occurrences.containsKey("Response") || occurrences.containsKey("Assertion"));
    }

    public boolean validateTimestamps() {
        NodeList timestampNodes = this.samlResponseDocument.getElementsByTagNameNS("*", "Conditions");
        if (timestampNodes.getLength() != 0) {
            for (int i = 0; i < timestampNodes.getLength(); ++i) {
                DateTime notBeforeDate;
                DateTime notOnOrAfterDate;
                NamedNodeMap attrName = timestampNodes.item(i).getAttributes();
                Node nbAttribute = attrName.getNamedItem("NotBefore");
                Node naAttribute = attrName.getNamedItem("NotOnOrAfter");
                if (naAttribute != null && ((notOnOrAfterDate = Util.parseDateTime(naAttribute.getNodeValue())).isEqualNow() || notOnOrAfterDate.isBeforeNow())) {
                    return false;
                }
                if (nbAttribute == null || !(notBeforeDate = Util.parseDateTime(nbAttribute.getNodeValue())).isAfterNow()) continue;
                return false;
            }
        }
        return true;
    }

    public void setDestinationUrl(String urld) {
        this.currentUrl = urld;
    }

    public String getError() {
        if (this.error != null) {
            return this.error.toString();
        }
        return null;
    }

    private NodeList queryAssertion(String assertionXpath) throws XPathExpressionException {
        String assertionExpr = "/saml:Assertion";
        String signatureExpr = "ds:Signature/ds:SignedInfo/ds:Reference";
        String nameQuery = "";
        String signedAssertionQuery = "/samlp:Response" + assertionExpr + "/" + signatureExpr;
        NodeList nodeList = this.query(signedAssertionQuery, null);
        if (nodeList.getLength() == 0) {
            String signedMessageQuery = "/samlp:Response/" + signatureExpr;
            nodeList = this.query(signedMessageQuery, null);
            if (nodeList.getLength() > 0) {
                Node responseReferenceNode = nodeList.item(0);
                String responseId = responseReferenceNode.getAttributes().getNamedItem("URI").getNodeValue();
                responseId = responseId != null && !responseId.isEmpty() ? responseId.substring(1) : responseReferenceNode.getParentNode().getParentNode().getParentNode().getAttributes().getNamedItem("ID").getNodeValue();
                nameQuery = "/samlp:Response[@ID='" + responseId + "']";
            } else {
                nameQuery = "/samlp:Response";
            }
            nameQuery = nameQuery + assertionExpr;
        } else {
            Node assertionReferenceNode = nodeList.item(0);
            String assertionId = assertionReferenceNode.getAttributes().getNamedItem("URI").getNodeValue();
            assertionId = assertionId != null && !assertionId.isEmpty() ? assertionId.substring(1) : assertionReferenceNode.getParentNode().getParentNode().getParentNode().getAttributes().getNamedItem("ID").getNodeValue();
            nameQuery = "/samlp:Response/" + assertionExpr + "[@ID='" + assertionId + "']";
        }
        nameQuery = nameQuery + assertionXpath;
        return this.query(nameQuery, null);
    }

    private NodeList query(String nameQuery, Node context) throws XPathExpressionException {
        Document doc = this.encrypted != false ? this.decryptedDocument : this.samlResponseDocument;
        return Util.query(doc, nameQuery, context);
    }

    private Document decryptAssertion(Document dom) throws Exception {
        PrivateKey key = this.settings.getSPkey();
        if (key == null) {
            throw new Exception("No private key available for decrypt, check settings");
        }
        NodeList encryptedDataNodes = Util.query(dom, "/samlp:Response/saml:EncryptedAssertion/xenc:EncryptedData");
        Element encryptedData = (Element)encryptedDataNodes.item(0);
        Util.decryptElement(encryptedData, key);
        NodeList AssertionDataNodes = Util.query(dom, "/samlp:Response/saml:EncryptedAssertion/saml:Assertion");
        Node assertionNode = AssertionDataNodes.item(0);
        assertionNode.getParentNode().getParentNode().replaceChild(assertionNode, assertionNode.getParentNode());
        String xmlStr = Util.convertDocumentToString(dom);
        Document doc = Util.convertStringToDocument(xmlStr);
        return doc;
    }
}

