/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2.authn;

import com.onelogin.saml2.model.Organization;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.util.Constants;
import com.onelogin.saml2.util.Util;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthnRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthnRequest.class);
    private final String authnRequestString;
    private final String id = Util.generateUniqueID();
    private final Saml2Settings settings;
    private final boolean forceAuthn;
    private final boolean isPassive;
    private final boolean setNameIdPolicy;
    private final Calendar issueInstant = Calendar.getInstance();

    public AuthnRequest(Saml2Settings settings) {
        this(settings, false, false, true);
    }

    public AuthnRequest(Saml2Settings settings, boolean forceAuthn, boolean isPassive, boolean setNameIdPolicy) {
        this.isPassive = isPassive;
        this.settings = settings;
        this.forceAuthn = forceAuthn;
        this.setNameIdPolicy = setNameIdPolicy;
        StrSubstitutor substitutor = this.generateSubstitutor(settings);
        this.authnRequestString = substitutor.replace((CharSequence)AuthnRequest.getAuthnRequestTemplate());
        LOGGER.debug("AuthNRequest --> " + this.authnRequestString);
    }

    public String getEncodedAuthnRequest(Boolean deflated) throws IOException {
        if (deflated == null) {
            deflated = this.settings.isCompressRequestEnabled();
        }
        String encodedAuthnRequest = deflated != false ? Util.deflatedBase64encoded(this.getAuthnRequestXml()) : Util.base64encoder(this.getAuthnRequestXml());
        return encodedAuthnRequest;
    }

    public String getEncodedAuthnRequest() throws IOException {
        return this.getEncodedAuthnRequest(null);
    }

    protected String getAuthnRequestXml() {
        return this.authnRequestString;
    }

    private StrSubstitutor generateSubstitutor(Saml2Settings settings) {
        String displayName;
        HashMap<String, String> valueMap = new HashMap<String, String>();
        String forceAuthnStr = "";
        if (this.forceAuthn) {
            forceAuthnStr = " ForceAuthn=\"true\"";
        }
        String isPassiveStr = "";
        if (this.isPassive) {
            isPassiveStr = " IsPassive=\"true\"";
        }
        valueMap.put("forceAuthnStr", forceAuthnStr);
        valueMap.put("isPassiveStr", isPassiveStr);
        String destinationStr = "";
        URL sso = settings.getIdpSingleSignOnServiceUrl();
        if (sso != null) {
            destinationStr = " Destination=\"" + sso.toString() + "\"";
        }
        valueMap.put("destinationStr", destinationStr);
        String nameIDPolicyStr = "";
        if (this.setNameIdPolicy) {
            String nameIDPolicyFormat = settings.getSpNameIDFormat();
            if (settings.getWantNameIdEncrypted().booleanValue()) {
                nameIDPolicyFormat = Constants.NAMEID_ENCRYPTED;
            }
            nameIDPolicyStr = "<samlp:NameIDPolicy Format=\"" + nameIDPolicyFormat + "\" AllowCreate=\"true\" />";
        }
        valueMap.put("nameIDPolicyStr", nameIDPolicyStr);
        String providerStr = "";
        Organization organization = settings.getOrganization();
        if (organization != null && !(displayName = organization.getOrgDisplayName()).isEmpty()) {
            providerStr = " ProviderName=\"" + displayName + "\"";
        }
        valueMap.put("providerStr", providerStr);
        String issueInstantString = Util.formatDateTime(this.issueInstant.getTimeInMillis());
        valueMap.put("issueInstant", issueInstantString);
        valueMap.put("id", String.valueOf(this.id));
        valueMap.put("assertionConsumerServiceURL", String.valueOf(settings.getSpAssertionConsumerServiceUrl()));
        valueMap.put("spEntityid", settings.getSpEntityId());
        String requestedAuthnContextStr = "";
        List<String> requestedAuthnContexts = settings.getRequestedAuthnContext();
        if (requestedAuthnContexts != null && !requestedAuthnContexts.isEmpty()) {
            String requestedAuthnContextCmp = settings.getRequestedAuthnContextComparison();
            requestedAuthnContextStr = "<samlp:RequestedAuthnContext Comparison=\"" + requestedAuthnContextCmp + "\">";
            for (String requestedAuthnContext : requestedAuthnContexts) {
                requestedAuthnContextStr = requestedAuthnContextStr + "<saml:AuthnContextClassRef>" + requestedAuthnContext + "</saml:AuthnContextClassRef>";
            }
            requestedAuthnContextStr = requestedAuthnContextStr + "</samlp:RequestedAuthnContext>";
        }
        valueMap.put("requestedAuthnContextStr", requestedAuthnContextStr);
        return new StrSubstitutor(valueMap);
    }

    private static StringBuilder getAuthnRequestTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<samlp:AuthnRequest xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" ID=\"${id}\" Version=\"2.0\" IssueInstant=\"${issueInstant}\"${providerStr}${forceAuthnStr}${isPassiveStr}${destinationStr} ProtocolBinding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\" AssertionConsumerServiceURL=\"${assertionConsumerServiceURL}\">");
        template.append("<saml:Issuer>${spEntityid}</saml:Issuer>");
        template.append("${nameIDPolicyStr}${requestedAuthnContextStr}</samlp:AuthnRequest>");
        return template;
    }

    public String getId() {
        return this.id;
    }
}

