/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.concurrency;

import com.onedrive.sdk.extensions.ChunkedUploadResult;
import com.onedrive.sdk.extensions.UploadSession;
import com.onedrive.sdk.http.DefaultHttpProvider;
import com.onedrive.sdk.http.IConnection;
import com.onedrive.sdk.http.IHttpRequest;
import com.onedrive.sdk.http.IStatefulResponseHandler;
import com.onedrive.sdk.http.OneDriveServiceException;
import com.onedrive.sdk.logger.ILogger;
import com.onedrive.sdk.serializer.ISerializer;
import java.io.BufferedInputStream;
import java.io.InputStream;

public class ChunkedUploadResponseHandler<UploadType>
implements IStatefulResponseHandler<ChunkedUploadResult, UploadType> {
    private final Class<UploadType> mDeserializeTypeClass;

    public ChunkedUploadResponseHandler(Class<UploadType> uploadType) {
        this.mDeserializeTypeClass = uploadType;
    }

    @Override
    public void configConnection(IConnection connection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChunkedUploadResult generateResult(IHttpRequest request, IConnection connection, ISerializer serializer, ILogger logger) throws Exception {
        try (InputStream in = null;){
            if (connection.getResponseCode() == 202) {
                logger.logDebug("Chunk bytes has been accepted by the server.");
                in = new BufferedInputStream(connection.getInputStream());
                UploadSession seesion = serializer.deserializeObject(DefaultHttpProvider.streamToString(in), UploadSession.class);
                ChunkedUploadResult chunkedUploadResult = new ChunkedUploadResult(seesion);
                return chunkedUploadResult;
            }
            if (connection.getResponseCode() == 201 || connection.getResponseCode() == 200) {
                logger.logDebug("Upload session is completed, uploaded item returned.");
                in = new BufferedInputStream(connection.getInputStream());
                String rawJson = DefaultHttpProvider.streamToString(in);
                UploadType uploadedItem = serializer.deserializeObject(rawJson, this.mDeserializeTypeClass);
                ChunkedUploadResult<UploadType> chunkedUploadResult = new ChunkedUploadResult<UploadType>(uploadedItem);
                return chunkedUploadResult;
            }
            if (connection.getResponseCode() >= 400) {
                logger.logDebug("Receiving error during upload, see detail on result error");
                ChunkedUploadResult chunkedUploadResult = new ChunkedUploadResult(OneDriveServiceException.createFromConnection(request, null, serializer, connection));
                return chunkedUploadResult;
            }
        }
        return null;
    }
}

