/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.http;

import com.onedrive.sdk.concurrency.AsyncMonitorLocation;
import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.concurrency.IExecutors;
import com.onedrive.sdk.concurrency.IProgressCallback;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.core.OneDriveErrorCodes;
import com.onedrive.sdk.extensions.AsyncOperationStatus;
import com.onedrive.sdk.http.DefaultConnectionFactory;
import com.onedrive.sdk.http.IConnection;
import com.onedrive.sdk.http.IConnectionFactory;
import com.onedrive.sdk.http.IHttpProvider;
import com.onedrive.sdk.http.IHttpRequest;
import com.onedrive.sdk.http.IRequestInterceptor;
import com.onedrive.sdk.http.OneDriveServiceException;
import com.onedrive.sdk.logger.ILogger;
import com.onedrive.sdk.logger.LoggerLevel;
import com.onedrive.sdk.serializer.ISerializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.Scanner;

public class DefaultHttpProvider
implements IHttpProvider {
    static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    static final String JSON_CONTENT_TYPE = "application/json";
    private final ISerializer mSerializer;
    private final IRequestInterceptor mRequestInterceptor;
    private final IExecutors mExecutors;
    private final ILogger mLogger;
    private IConnectionFactory mConnectionFactory;

    public DefaultHttpProvider(ISerializer serializer, IRequestInterceptor requestInterceptor, IExecutors executors, ILogger logger) {
        this.mSerializer = serializer;
        this.mRequestInterceptor = requestInterceptor;
        this.mExecutors = executors;
        this.mLogger = logger;
        this.mConnectionFactory = new DefaultConnectionFactory();
    }

    @Override
    public ISerializer getSerializer() {
        return this.mSerializer;
    }

    public <Result, Body> void send(final IHttpRequest request, final ICallback<Result> callback, final Class<Result> resultClass, final Body serializable) {
        final IProgressCallback progressCallback = callback instanceof IProgressCallback ? (IProgressCallback)callback : null;
        this.mExecutors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultHttpProvider.this.mExecutors.performOnForeground(DefaultHttpProvider.this.sendRequestInternal(request, resultClass, serializable, progressCallback), callback);
                }
                catch (ClientException e) {
                    DefaultHttpProvider.this.mExecutors.performOnForeground(e, callback);
                }
            }
        });
    }

    public <Result, Body> Result send(IHttpRequest request, Class<Result> resultClass, Body serializable) throws ClientException {
        return this.sendRequestInternal(request, resultClass, serializable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <Result, Body> Result sendRequestInternal(IHttpRequest request, Class<Result> resultClass, Body serializable, IProgressCallback<Result> progress) throws ClientException {
        int defaultBufferSize = 4096;
        String contentLengthHeaderName = "Content-Length";
        String binaryContentType = "application/octet-stream";
        int httpClientErrorResponseCode = 400;
        int httpNoBodyResponseCode = 204;
        int httpAcceptedResponseCode = 202;
        int httpSeeOtherResponseCode = 303;
        int httpNotModified = 304;
        try {
            if (this.mRequestInterceptor != null) {
                this.mRequestInterceptor.intercept(request);
            }
            OutputStream out = null;
            InputStream in = null;
            boolean isBinaryStreamInput = false;
            URL requestUrl = request.getRequestUrl();
            this.mLogger.logDebug("Starting to send request, URL " + requestUrl.toString());
            IConnection connection = this.mConnectionFactory.createFromRequest(request);
            try {
                Object writtenSoFar2;
                BufferedOutputStream bos;
                byte[] bytesToWrite;
                this.mLogger.logDebug("Request Method " + request.getHttpMethod().toString());
                connection.setFollowRedirects(!this.isAsyncOperation(resultClass));
                if (serializable == null) {
                    bytesToWrite = null;
                } else if (serializable instanceof byte[]) {
                    this.mLogger.logDebug("Sending byte[] as request body");
                    bytesToWrite = (byte[])serializable;
                    connection.addRequestHeader(CONTENT_TYPE_HEADER_NAME, "application/octet-stream");
                    connection.setContentLength(bytesToWrite.length);
                } else {
                    this.mLogger.logDebug("Sending " + serializable.getClass().getName() + " as request body");
                    String serializeObject = this.mSerializer.serializeObject(serializable);
                    bytesToWrite = serializeObject.getBytes();
                    connection.addRequestHeader(CONTENT_TYPE_HEADER_NAME, JSON_CONTENT_TYPE);
                    connection.setContentLength(bytesToWrite.length);
                }
                if (bytesToWrite != null) {
                    int toWrite;
                    out = connection.getOutputStream();
                    int writtenSoFar2 = 0;
                    bos = new BufferedOutputStream(out);
                    do {
                        toWrite = Math.min(4096, bytesToWrite.length - writtenSoFar2);
                        bos.write(bytesToWrite, writtenSoFar2, toWrite);
                        writtenSoFar2 += toWrite;
                        if (progress == null) continue;
                        this.mExecutors.performOnForeground(writtenSoFar2, bytesToWrite.length, progress);
                    } while (toWrite > 0);
                    bos.close();
                }
                this.mLogger.logDebug(String.format("Response code %d, %s", connection.getResponseCode(), connection.getResponseMessage()));
                if (connection.getResponseCode() >= 400 && !this.isAsyncOperation(resultClass)) {
                    this.mLogger.logDebug("Handling error response");
                    in = connection.getInputStream();
                    this.handleErrorResponse(request, serializable, connection);
                }
                if (connection.getResponseCode() == 204 || connection.getResponseCode() == 304) {
                    this.mLogger.logDebug("Handling response with no body");
                    writtenSoFar2 = null;
                    return (Result)writtenSoFar2;
                }
                if (connection.getResponseCode() == 202) {
                    this.mLogger.logDebug("Handling accepted response");
                    if (resultClass == AsyncMonitorLocation.class) {
                        writtenSoFar2 = new AsyncMonitorLocation(connection.getHeaders().get("Location"));
                        return (Result)writtenSoFar2;
                    }
                }
                if (this.isAsyncOperation(resultClass)) {
                    this.mLogger.logDebug("Use different rules for processing async operations");
                    if (connection.getResponseCode() == 303) {
                        writtenSoFar2 = AsyncOperationStatus.createdCompleted(connection.getHeaders().get("Location"));
                        return (Result)writtenSoFar2;
                    }
                    in = new BufferedInputStream(connection.getInputStream());
                    Result result = this.handleJsonResponse(in, resultClass);
                    ((AsyncOperationStatus)result).seeOther = connection.getHeaders().get("Location");
                    bos = result;
                    return (Result)bos;
                }
                in = new BufferedInputStream(connection.getInputStream());
                Map<String, String> headers = connection.getHeaders();
                String contentType = headers.get(CONTENT_TYPE_HEADER_NAME);
                if (contentType.contains(JSON_CONTENT_TYPE)) {
                    this.mLogger.logDebug("Response json");
                    Result Result = this.handleJsonResponse(in, resultClass);
                    return Result;
                }
                this.mLogger.logDebug("Response binary");
                isBinaryStreamInput = true;
                InputStream inputStream = this.handleBinaryStream(in);
                return (Result)inputStream;
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (!isBinaryStreamInput && in != null) {
                    in.close();
                    connection.close();
                }
            }
        }
        catch (OneDriveServiceException ex) {
            boolean shouldLogVerbosely = this.mLogger.getLoggingLevel() == LoggerLevel.Debug;
            this.mLogger.logError("OneDrive Service exception " + ex.getMessage(shouldLogVerbosely), ex);
            throw ex;
        }
        catch (Exception ex) {
            ClientException clientException = new ClientException("Error during http request", ex, OneDriveErrorCodes.GeneralException);
            this.mLogger.logError("Error during http request", clientException);
            throw clientException;
        }
    }

    private boolean isAsyncOperation(Class resultClass) {
        return resultClass == AsyncOperationStatus.class;
    }

    private <Body> void handleErrorResponse(IHttpRequest request, Body serializable, IConnection connection) throws IOException {
        throw OneDriveServiceException.createFromConnection(request, serializable, this.mSerializer, connection);
    }

    private InputStream handleBinaryStream(InputStream in) {
        return in;
    }

    private <Result> Result handleJsonResponse(InputStream in, Class<Result> clazz) {
        if (clazz == null) {
            return null;
        }
        String rawJson = DefaultHttpProvider.streamToString(in);
        return this.getSerializer().deserializeObject(rawJson, clazz);
    }

    void setConnectionFactory(IConnectionFactory factory) {
        this.mConnectionFactory = factory;
    }

    public static String streamToString(InputStream input) {
        String httpStreamEncoding = "UTF-8";
        String endOfFile = "\\A";
        Scanner scanner = new Scanner(input, "UTF-8").useDelimiter("\\A");
        return scanner.next();
    }
}

