/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.IShareRequest;
import com.onedrive.sdk.extensions.Share;
import com.onedrive.sdk.extensions.ShareRequest;
import com.onedrive.sdk.generated.IBaseShareRequest;
import com.onedrive.sdk.http.BaseRequest;
import com.onedrive.sdk.http.HttpMethod;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseShareRequest
extends BaseRequest
implements IBaseShareRequest {
    public BaseShareRequest(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options, Share.class);
    }

    @Override
    public void get(ICallback<Share> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Share get() throws ClientException {
        return (Share)this.send(HttpMethod.GET, null);
    }

    @Override
    @Deprecated
    public void update(Share sourceShare, ICallback<Share> callback) {
        this.patch(sourceShare, callback);
    }

    @Override
    @Deprecated
    public Share update(Share sourceShare) throws ClientException {
        return this.patch(sourceShare);
    }

    @Override
    public void patch(Share sourceShare, ICallback<Share> callback) {
        this.send(HttpMethod.PATCH, callback, sourceShare);
    }

    @Override
    public Share patch(Share sourceShare) throws ClientException {
        return (Share)this.send(HttpMethod.PATCH, sourceShare);
    }

    @Override
    public void delete(ICallback<Void> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    @Deprecated
    public void create(Share newShare, ICallback<Share> callback) {
        this.post(newShare, callback);
    }

    @Override
    @Deprecated
    public Share create(Share newShare) throws ClientException {
        return this.post(newShare);
    }

    @Override
    public void post(Share newShare, ICallback<Share> callback) {
        this.send(HttpMethod.POST, callback, newShare);
    }

    @Override
    public Share post(Share newShare) throws ClientException {
        return (Share)this.send(HttpMethod.POST, newShare);
    }

    @Override
    public IShareRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("select", value));
        return (ShareRequest)this;
    }

    @Override
    public IShareRequest top(int value) {
        this.getQueryOptions().add(new QueryOption("top", value + ""));
        return (ShareRequest)this;
    }

    @Override
    public IShareRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("expand", value));
        return (ShareRequest)this;
    }
}

