/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.concurrency.IExecutors;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.DeltaCollectionPage;
import com.onedrive.sdk.extensions.DeltaRequest;
import com.onedrive.sdk.extensions.DeltaRequestBuilder;
import com.onedrive.sdk.extensions.IDeltaCollectionPage;
import com.onedrive.sdk.extensions.IDeltaRequest;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.generated.BaseDeltaCollectionResponse;
import com.onedrive.sdk.generated.IBaseDeltaRequest;
import com.onedrive.sdk.http.BaseCollectionRequest;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseDeltaRequest
extends BaseCollectionRequest<BaseDeltaCollectionResponse, IDeltaCollectionPage>
implements IBaseDeltaRequest {
    public BaseDeltaRequest(String requestUrl, IOneDriveClient client, List<Option> options, String token) {
        super(requestUrl, client, options, BaseDeltaCollectionResponse.class, IDeltaCollectionPage.class);
        if (token != null) {
            this.addQueryOption(new QueryOption("token", token));
        }
    }

    @Override
    public void get(final ICallback<IDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeltaRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeltaCollectionPage get() throws ClientException {
        BaseDeltaCollectionResponse response = (BaseDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IDeltaRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (DeltaRequest)this;
    }

    @Override
    public IDeltaRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (DeltaRequest)this;
    }

    @Override
    public IDeltaRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (DeltaRequest)this;
    }

    public IDeltaCollectionPage buildFromResponse(BaseDeltaCollectionResponse response) {
        DeltaRequestBuilder builder = response.nextLink != null ? new DeltaRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null) : null;
        DeltaCollectionPage page = new DeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

