/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.extensions;

import android.app.Activity;
import com.onedrive.sdk.authentication.ClientAuthenticatorException;
import com.onedrive.sdk.authentication.IAccountInfo;
import com.onedrive.sdk.authentication.IAuthenticator;
import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.concurrency.IExecutors;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.core.IClientConfig;
import com.onedrive.sdk.core.OneDriveErrorCodes;
import com.onedrive.sdk.extensions.DriveRequestBuilder;
import com.onedrive.sdk.extensions.IDriveRequestBuilder;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.generated.BaseOneDriveClient;
import com.onedrive.sdk.http.IHttpProvider;
import com.onedrive.sdk.logger.ILogger;
import com.onedrive.sdk.serializer.ISerializer;

public class OneDriveClient
extends BaseOneDriveClient
implements IOneDriveClient {
    protected OneDriveClient() {
    }

    @Override
    public IDriveRequestBuilder getDrive() {
        return new DriveRequestBuilder(this.getServiceRoot() + "/drive", this, null);
    }

    public static class Builder {
        private final OneDriveClient mClient = new OneDriveClient();

        public Builder serializer(ISerializer serializer) {
            this.mClient.setSerializer(serializer);
            return this;
        }

        public Builder httpProvider(IHttpProvider httpProvider) {
            this.mClient.setHttpProvider(httpProvider);
            return this;
        }

        public Builder authenticator(IAuthenticator authenticator) {
            this.mClient.setAuthenticator(authenticator);
            return this;
        }

        public Builder executors(IExecutors executors) {
            this.mClient.setExecutors(executors);
            return this;
        }

        private Builder logger(ILogger logger) {
            this.mClient.setLogger(logger);
            return this;
        }

        public Builder fromConfig(IClientConfig clientConfig) {
            return this.authenticator(clientConfig.getAuthenticator()).executors(clientConfig.getExecutors()).httpProvider(clientConfig.getHttpProvider()).logger(clientConfig.getLogger()).serializer(clientConfig.getSerializer());
        }

        public void loginAndBuildClient(final Activity activity, final ICallback<IOneDriveClient> callback) {
            this.mClient.validate();
            this.mClient.getExecutors().performOnBackground(new Runnable(){

                @Override
                public void run() {
                    IExecutors executors = Builder.this.mClient.getExecutors();
                    try {
                        executors.performOnForeground(Builder.this.loginAndBuildClient(activity), callback);
                    }
                    catch (ClientException e) {
                        executors.performOnForeground(e, callback);
                    }
                }
            });
        }

        public IOneDriveClient loginAndBuildClient(Activity activity) throws ClientException {
            this.mClient.validate();
            this.mClient.getAuthenticator().init(this.mClient.getExecutors(), this.mClient.getHttpProvider(), activity, this.mClient.getLogger());
            IAccountInfo silentAccountInfo = null;
            try {
                silentAccountInfo = this.mClient.getAuthenticator().loginSilent();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (silentAccountInfo == null && this.mClient.getAuthenticator().login(null) == null) {
                throw new ClientAuthenticatorException("Unable to authenticate silently or interactively", OneDriveErrorCodes.AuthenticationFailure);
            }
            return this.mClient;
        }
    }
}

