/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.concurrency;

import com.onedrive.sdk.concurrency.AsyncMonitorLocation;
import com.onedrive.sdk.concurrency.AsyncOperationException;
import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.concurrency.IProgressCallback;
import com.onedrive.sdk.concurrency.ResultGetter;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.core.OneDriveErrorCodes;
import com.onedrive.sdk.extensions.AsyncOperationStatus;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.http.BaseRequest;
import com.onedrive.sdk.http.HttpMethod;

public class AsyncMonitor<T> {
    private final IOneDriveClient mClient;
    private final AsyncMonitorLocation mMonitorLocation;
    private final ResultGetter<T> mResultGetter;

    public AsyncMonitor(IOneDriveClient client, AsyncMonitorLocation monitorLocation, ResultGetter<T> resultGetter) {
        this.mClient = client;
        this.mMonitorLocation = monitorLocation;
        this.mResultGetter = resultGetter;
    }

    public void getStatus(final ICallback<AsyncOperationStatus> callback) {
        this.mClient.getExecutors().performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncMonitor.this.mClient.getExecutors().performOnForeground(AsyncMonitor.this.getStatus(), callback);
                }
                catch (ClientException e) {
                    AsyncMonitor.this.mClient.getExecutors().performOnForeground(e, callback);
                }
            }
        });
    }

    public AsyncOperationStatus getStatus() throws ClientException {
        BaseRequest monitorStatusRequest = new BaseRequest(this.mMonitorLocation.getLocation(), this.mClient, null, null){};
        monitorStatusRequest.setHttpMethod(HttpMethod.GET);
        return this.mClient.getHttpProvider().send(monitorStatusRequest, AsyncOperationStatus.class, null);
    }

    public void getResult(final ICallback<T> callback) {
        this.mClient.getExecutors().performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncMonitor.this.mClient.getExecutors().performOnForeground(AsyncMonitor.this.getResult(), callback);
                }
                catch (ClientException e) {
                    AsyncMonitor.this.mClient.getExecutors().performOnForeground(e, callback);
                }
            }
        });
    }

    public T getResult() throws ClientException {
        AsyncOperationStatus status = this.getStatus();
        if (status.seeOther == null) {
            throw new ClientException("Async operation '" + status.operation + "' has not completed!", null, OneDriveErrorCodes.AsyncTaskNotCompleted);
        }
        return this.mResultGetter.getResultFrom(status.seeOther, this.mClient);
    }

    public void pollForResult(final long millisBetweenPoll, final IProgressCallback<T> callback) {
        int progressMax = 100;
        this.mClient.getLogger().logDebug("Starting to poll for request " + this.mMonitorLocation.getLocation());
        this.mClient.getExecutors().performOnBackground(new Runnable(){

            @Override
            public void run() {
                AsyncOperationStatus status = null;
                try {
                    do {
                        if (status != null) {
                            try {
                                Thread.sleep(millisBetweenPoll);
                            }
                            catch (InterruptedException ignored) {
                                AsyncMonitor.this.mClient.getLogger().logDebug("InterruptedException ignored");
                            }
                        }
                        status = AsyncMonitor.this.getStatus();
                        if (status.percentageComplete == null) continue;
                        AsyncMonitor.this.mClient.getExecutors().performOnForeground(status.percentageComplete.intValue(), 100, callback);
                    } while (!AsyncMonitor.this.isCompleted(status) && !AsyncMonitor.this.isFailed(status));
                    AsyncMonitor.this.mClient.getLogger().logDebug("Polling has completed, got final status: " + status.status);
                    if (AsyncMonitor.this.isFailed(status)) {
                        AsyncMonitor.this.mClient.getExecutors().performOnForeground(new AsyncOperationException(status), callback);
                    }
                    AsyncMonitor.this.mClient.getExecutors().performOnForeground(AsyncMonitor.this.getResult(), callback);
                }
                catch (ClientException e) {
                    AsyncMonitor.this.mClient.getExecutors().performOnForeground(e, callback);
                }
            }
        });
    }

    private boolean isCompleted(AsyncOperationStatus status) {
        return status.status.equalsIgnoreCase("completed");
    }

    private boolean isFailed(AsyncOperationStatus status) {
        return status.status.equalsIgnoreCase("failed");
    }
}

