// ------------------------------------------------------------------------------
// Copyright (c) 2015 Microsoft Corporation
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.*;
import com.onedrive.sdk.core.*;
import com.onedrive.sdk.extensions.*;
import com.onedrive.sdk.http.*;
import com.onedrive.sdk.generated.*;
import com.onedrive.sdk.options.*;
import com.onedrive.sdk.serializer.*;

import java.util.*;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Share Collection Request.
 */
public class BaseShareCollectionRequest extends BaseCollectionRequest<BaseShareCollectionResponse, IShareCollectionPage> implements IBaseShareCollectionRequest {

    /**
     * The request builder for this collection of Share
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseShareCollectionRequest(final String requestUrl, IOneDriveClient client, final List<Option> options) {
        super(requestUrl, client, options, BaseShareCollectionResponse.class, IShareCollectionPage.class);
    }

    public IShareCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("expand", value));
        return (ShareCollectionRequest)this;
    }

    public IShareCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("select", value));
        return (ShareCollectionRequest)this;
    }

    public IShareCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("top", value + ""));
        return (ShareCollectionRequest)this;
    }

    public IShareCollectionPage buildFromResponse(final BaseShareCollectionResponse response) {
        final IShareCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new ShareCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final ShareCollectionPage page = new ShareCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
