/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.IThumbnailSetRequest;
import com.onedrive.sdk.extensions.ThumbnailSet;
import com.onedrive.sdk.extensions.ThumbnailSetRequest;
import com.onedrive.sdk.generated.IBaseThumbnailSetRequest;
import com.onedrive.sdk.http.BaseRequest;
import com.onedrive.sdk.http.HttpMethod;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseThumbnailSetRequest
extends BaseRequest
implements IBaseThumbnailSetRequest {
    public BaseThumbnailSetRequest(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options, ThumbnailSet.class);
    }

    @Override
    public void get(ICallback<ThumbnailSet> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public ThumbnailSet get() throws ClientException {
        return (ThumbnailSet)this.send(HttpMethod.GET, null);
    }

    @Override
    @Deprecated
    public void update(ThumbnailSet sourceThumbnailSet, ICallback<ThumbnailSet> callback) {
        this.patch(sourceThumbnailSet, callback);
    }

    @Override
    @Deprecated
    public ThumbnailSet update(ThumbnailSet sourceThumbnailSet) throws ClientException {
        return this.patch(sourceThumbnailSet);
    }

    @Override
    public void patch(ThumbnailSet sourceThumbnailSet, ICallback<ThumbnailSet> callback) {
        this.send(HttpMethod.PATCH, callback, sourceThumbnailSet);
    }

    @Override
    public ThumbnailSet patch(ThumbnailSet sourceThumbnailSet) throws ClientException {
        return (ThumbnailSet)this.send(HttpMethod.PATCH, sourceThumbnailSet);
    }

    @Override
    public void delete(ICallback<Void> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    @Deprecated
    public void create(ThumbnailSet newThumbnailSet, ICallback<ThumbnailSet> callback) {
        this.post(newThumbnailSet, callback);
    }

    @Override
    @Deprecated
    public ThumbnailSet create(ThumbnailSet newThumbnailSet) throws ClientException {
        return this.post(newThumbnailSet);
    }

    @Override
    public void post(ThumbnailSet newThumbnailSet, ICallback<ThumbnailSet> callback) {
        this.send(HttpMethod.POST, callback, newThumbnailSet);
    }

    @Override
    public ThumbnailSet post(ThumbnailSet newThumbnailSet) throws ClientException {
        return (ThumbnailSet)this.send(HttpMethod.POST, newThumbnailSet);
    }

    @Override
    public IThumbnailSetRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("select", value));
        return (ThumbnailSetRequest)this;
    }

    @Override
    public IThumbnailSetRequest top(int value) {
        this.getQueryOptions().add(new QueryOption("top", value + ""));
        return (ThumbnailSetRequest)this;
    }

    @Override
    public IThumbnailSetRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("expand", value));
        return (ThumbnailSetRequest)this;
    }
}

