/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.IStringCollectionPage;
import com.onedrive.sdk.extensions.IStringCollectionRequest;
import com.onedrive.sdk.extensions.StringCollectionPage;
import com.onedrive.sdk.extensions.StringCollectionRequest;
import com.onedrive.sdk.extensions.StringCollectionRequestBuilder;
import com.onedrive.sdk.generated.BaseStringCollectionResponse;
import com.onedrive.sdk.generated.IBaseStringCollectionRequest;
import com.onedrive.sdk.http.BaseCollectionRequest;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseStringCollectionRequest
extends BaseCollectionRequest<BaseStringCollectionResponse, IStringCollectionPage>
implements IBaseStringCollectionRequest {
    public BaseStringCollectionRequest(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options, BaseStringCollectionResponse.class, IStringCollectionPage.class);
    }

    @Override
    public IStringCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (StringCollectionRequest)this;
    }

    @Override
    public IStringCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (StringCollectionRequest)this;
    }

    @Override
    public IStringCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (StringCollectionRequest)this;
    }

    public IStringCollectionPage buildFromResponse(BaseStringCollectionResponse response) {
        StringCollectionRequestBuilder builder = response.nextLink != null ? new StringCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        StringCollectionPage page = new StringCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

