/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.concurrency.IExecutors;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.ISearchCollectionPage;
import com.onedrive.sdk.extensions.ISearchRequest;
import com.onedrive.sdk.extensions.SearchCollectionPage;
import com.onedrive.sdk.extensions.SearchRequest;
import com.onedrive.sdk.extensions.SearchRequestBuilder;
import com.onedrive.sdk.generated.BaseSearchCollectionResponse;
import com.onedrive.sdk.generated.IBaseSearchRequest;
import com.onedrive.sdk.http.BaseCollectionRequest;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseSearchRequest
extends BaseCollectionRequest<BaseSearchCollectionResponse, ISearchCollectionPage>
implements IBaseSearchRequest {
    public BaseSearchRequest(String requestUrl, IOneDriveClient client, List<Option> options, String q) {
        super(requestUrl, client, options, BaseSearchCollectionResponse.class, ISearchCollectionPage.class);
        if (q != null) {
            this.addQueryOption(new QueryOption("q", q));
        }
    }

    @Override
    public void get(final ICallback<ISearchCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseSearchRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISearchCollectionPage get() throws ClientException {
        BaseSearchCollectionResponse response = (BaseSearchCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public ISearchRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (SearchRequest)this;
    }

    @Override
    public ISearchRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (SearchRequest)this;
    }

    @Override
    public ISearchRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (SearchRequest)this;
    }

    public ISearchCollectionPage buildFromResponse(BaseSearchCollectionResponse response) {
        SearchRequestBuilder builder = response.nextLink != null ? new SearchRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null) : null;
        SearchCollectionPage page = new SearchCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

