/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.concurrency.IExecutors;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.IItemCollectionPage;
import com.onedrive.sdk.extensions.IItemCollectionRequest;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.Item;
import com.onedrive.sdk.extensions.ItemCollectionPage;
import com.onedrive.sdk.extensions.ItemCollectionRequest;
import com.onedrive.sdk.extensions.ItemCollectionRequestBuilder;
import com.onedrive.sdk.extensions.ItemRequestBuilder;
import com.onedrive.sdk.generated.BaseItemCollectionResponse;
import com.onedrive.sdk.generated.IBaseItemCollectionRequest;
import com.onedrive.sdk.http.BaseCollectionRequest;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseItemCollectionRequest
extends BaseCollectionRequest<BaseItemCollectionResponse, IItemCollectionPage>
implements IBaseItemCollectionRequest {
    public BaseItemCollectionRequest(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options, BaseItemCollectionResponse.class, IItemCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IItemCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseItemCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IItemCollectionPage get() throws ClientException {
        BaseItemCollectionResponse response = (BaseItemCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    @Deprecated
    public void create(Item newItem, ICallback<Item> callback) {
        this.post(newItem, callback);
    }

    @Override
    @Deprecated
    public Item create(Item newItem) throws ClientException {
        return this.post(newItem);
    }

    @Override
    public void post(Item newItem, ICallback<Item> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newItem, callback);
    }

    @Override
    public Item post(Item newItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newItem);
    }

    @Override
    public IItemCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (ItemCollectionRequest)this;
    }

    @Override
    public IItemCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (ItemCollectionRequest)this;
    }

    @Override
    public IItemCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (ItemCollectionRequest)this;
    }

    public IItemCollectionPage buildFromResponse(BaseItemCollectionResponse response) {
        ItemCollectionRequestBuilder builder = response.nextLink != null ? new ItemCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ItemCollectionPage page = new ItemCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

