/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.authentication;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.microsoft.aad.adal.AuthenticationCallback;
import com.microsoft.aad.adal.AuthenticationCancelError;
import com.microsoft.aad.adal.AuthenticationContext;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.PromptBehavior;
import com.onedrive.sdk.authentication.ADALAccountInfo;
import com.onedrive.sdk.authentication.ClientAuthenticatorException;
import com.onedrive.sdk.authentication.DiscoveryServiceResponse;
import com.onedrive.sdk.authentication.IAccountInfo;
import com.onedrive.sdk.authentication.IAuthenticator;
import com.onedrive.sdk.authentication.ServiceInfo;
import com.onedrive.sdk.authentication.adal.BrokerPermissionsChecker;
import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.concurrency.IExecutors;
import com.onedrive.sdk.concurrency.SimpleWaiter;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.core.OneDriveErrorCodes;
import com.onedrive.sdk.http.BaseRequest;
import com.onedrive.sdk.http.HttpMethod;
import com.onedrive.sdk.http.IHttpProvider;
import com.onedrive.sdk.logger.ILogger;
import com.onedrive.sdk.options.HeaderOption;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.NoSuchPaddingException;

public abstract class ADALAuthenticator
implements IAuthenticator {
    private static final String LOGIN_AUTHORITY = "https://login.windows.net/common/oauth2/authorize";
    private static final String DISCOVERY_SERVICE_URL = "https://api.office.com/discovery/v2.0/me/Services";
    private static final String DISCOVER_SERVICE_RESOURCE_ID = "https://api.office.com/discovery/";
    private static final String ADAL_AUTHENTICATOR_PREFS = "ADALAuthenticatorPrefs";
    private static final String USER_ID_KEY = "userId";
    private static final String RESOURCE_URL_KEY = "resourceUrl";
    private static final String SERVICE_INFO_KEY = "serviceInfo";
    private static final String VERSION_CODE_KEY = "versionCode";
    private static final boolean VALIDATE_AUTHORITY = true;
    private final AtomicReference<String> mResourceUrl = new AtomicReference();
    private final AtomicReference<String> mUserId = new AtomicReference();
    private final AtomicReference<ServiceInfo> mOneDriveServiceInfo = new AtomicReference();
    private final AtomicReference<IAccountInfo> mAccountInfo = new AtomicReference();
    private boolean mInitialized;
    private Activity mActivity;
    private IHttpProvider mHttpProvider;
    private IExecutors mExecutors;
    private AuthenticationContext mAdalContext;
    private ILogger mLogger;

    protected abstract String getClientId();

    protected abstract String getRedirectUrl();

    @Override
    public IAccountInfo getAccountInfo() {
        return this.mAccountInfo.get();
    }

    @Override
    public synchronized void init(IExecutors executors, IHttpProvider httpProvider, Activity activity, ILogger logger) {
        if (this.mInitialized) {
            return;
        }
        this.mExecutors = executors;
        this.mHttpProvider = httpProvider;
        this.mActivity = activity;
        this.mLogger = logger;
        BrokerPermissionsChecker brokerPermissionsChecker = new BrokerPermissionsChecker((Context)this.mActivity, this.mLogger);
        brokerPermissionsChecker.check();
        try {
            this.mAdalContext = new AuthenticationContext((Context)activity, LOGIN_AUTHORITY, true);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            ClientAuthenticatorException exception = new ClientAuthenticatorException("Unable to access required cryptographic libraries for ADAL", e, OneDriveErrorCodes.AuthenticationFailure);
            this.mLogger.logError("Problem creating the AuthenticationContext for ADAL", exception);
            throw exception;
        }
        SharedPreferences prefs = this.getSharedPreferences();
        this.mUserId.set(prefs.getString(USER_ID_KEY, null));
        this.mResourceUrl.set(prefs.getString(RESOURCE_URL_KEY, null));
        String serviceInfoAsString = prefs.getString(SERVICE_INFO_KEY, null);
        ServiceInfo serviceInfo = null;
        try {
            if (serviceInfoAsString != null) {
                serviceInfo = this.mHttpProvider.getSerializer().deserializeObject(serviceInfoAsString, ServiceInfo.class);
            }
        }
        catch (Exception ex) {
            this.mLogger.logError("Unable to parse serviceInfo from saved preferences", ex);
        }
        this.mOneDriveServiceInfo.set(serviceInfo);
        this.mInitialized = true;
        if (this.mUserId.get() != null || this.mResourceUrl.get() != null || this.mOneDriveServiceInfo.get() != null) {
            this.mLogger.logDebug("Found existing login information");
            if (this.mUserId.get() == null || this.mResourceUrl.get() == null || this.mOneDriveServiceInfo.get() == null) {
                this.mLogger.logDebug("Existing login information was incompletely, flushing sign in state");
                this.logout();
            }
        }
    }

    @Override
    public void login(final String emailAddressHint, final ICallback<IAccountInfo> loginCallback) {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        if (loginCallback == null) {
            throw new IllegalArgumentException("loginCallback");
        }
        this.mLogger.logDebug("Starting login async");
        this.mExecutors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    loginCallback.success(ADALAuthenticator.this.login(emailAddressHint));
                }
                catch (ClientException e) {
                    loginCallback.failure(e);
                }
            }
        });
    }

    @Override
    public synchronized IAccountInfo login(String emailAddressHint) throws ClientException {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        this.mLogger.logDebug("Starting login");
        AuthenticationResult discoveryServiceAuthToken = this.getDiscoveryServiceAuthResult(emailAddressHint);
        if (discoveryServiceAuthToken.getStatus() != AuthenticationResult.AuthenticationStatus.Succeeded) {
            ClientAuthenticatorException clientAuthenticatorException = new ClientAuthenticatorException("Unable to authenticate user with ADAL, Error Code: " + discoveryServiceAuthToken.getErrorCode() + " Error Message" + discoveryServiceAuthToken.getErrorDescription(), OneDriveErrorCodes.AuthenticationFailure);
            this.mLogger.logError("Unsuccessful login attempt", clientAuthenticatorException);
            throw clientAuthenticatorException;
        }
        ServiceInfo oneDriveServiceInfo = this.getOneDriveServiceInfoFromDiscoveryService(discoveryServiceAuthToken.getAccessToken());
        AuthenticationResult oneDriveServiceAuthToken = this.getOneDriveServiceAuthResult(oneDriveServiceInfo);
        String serviceInfoAsString = this.mHttpProvider.getSerializer().serializeObject(oneDriveServiceInfo);
        this.mLogger.logDebug("Successful login, saving information for silent re-auth");
        SharedPreferences preferences = this.getSharedPreferences();
        this.mResourceUrl.set(oneDriveServiceInfo.serviceEndpointUri);
        this.mUserId.set(discoveryServiceAuthToken.getUserInfo().getUserId());
        this.mOneDriveServiceInfo.set(oneDriveServiceInfo);
        preferences.edit().putString(RESOURCE_URL_KEY, this.mResourceUrl.get()).putString(USER_ID_KEY, this.mUserId.get()).putString(SERVICE_INFO_KEY, serviceInfoAsString).putInt(VERSION_CODE_KEY, 10200).apply();
        this.mLogger.logDebug("Successfully retrieved login information");
        this.mLogger.logDebug("   Resource Url: " + this.mResourceUrl.get());
        this.mLogger.logDebug("   User ID: " + this.mUserId.get());
        this.mLogger.logDebug("   Service Info: " + serviceInfoAsString);
        ADALAccountInfo adalAccountInfo = new ADALAccountInfo(this, oneDriveServiceAuthToken, oneDriveServiceInfo, this.mLogger);
        this.mAccountInfo.set(adalAccountInfo);
        return this.mAccountInfo.get();
    }

    @Override
    public void loginSilent(final ICallback<IAccountInfo> loginCallback) {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        if (loginCallback == null) {
            throw new IllegalArgumentException("loginCallback");
        }
        this.mLogger.logDebug("Starting login silent async");
        this.mExecutors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    ADALAuthenticator.this.mExecutors.performOnForeground(ADALAuthenticator.this.loginSilent(), loginCallback);
                }
                catch (ClientException e) {
                    ADALAuthenticator.this.mExecutors.performOnForeground(e, loginCallback);
                }
            }
        });
    }

    @Override
    public synchronized IAccountInfo loginSilent() throws ClientException {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        this.mLogger.logDebug("Starting login silent");
        if (this.mResourceUrl.get() == null) {
            this.mLogger.logDebug("No login information found for silent authentication");
            return null;
        }
        final SimpleWaiter loginSilentWaiter = new SimpleWaiter();
        final AtomicReference authResult = new AtomicReference();
        final AtomicReference error = new AtomicReference();
        AuthenticationCallback<AuthenticationResult> callback = new AuthenticationCallback<AuthenticationResult>(){

            public void onSuccess(AuthenticationResult authenticationResult) {
                String userId = authenticationResult.getUserInfo() == null ? "Invalid User Id" : authenticationResult.getUserInfo().getUserId();
                String tenantId = authenticationResult.getTenantId();
                ADALAuthenticator.this.mLogger.logDebug(String.format("Successful silent auth for user id '%s', tenant id '%s'", userId, tenantId));
                authResult.set(authenticationResult);
                loginSilentWaiter.signal();
            }

            public void onError(Exception e) {
                String message = "Silent authentication failure from ADAL";
                if (e instanceof AuthenticationException) {
                    message = String.format("%s; Code %s", message, ((AuthenticationException)e).getCode().getDescription());
                }
                ADALAuthenticator.this.mLogger.logDebug(message);
                error.set(new ClientAuthenticatorException(message, e, OneDriveErrorCodes.AuthenticationFailure));
                loginSilentWaiter.signal();
            }
        };
        this.mAdalContext.acquireTokenSilent(this.mOneDriveServiceInfo.get().serviceResourceId, this.getClientId(), this.mUserId.get(), (AuthenticationCallback)callback);
        loginSilentWaiter.waitForSignal();
        if (error.get() != null) {
            throw (ClientException)error.get();
        }
        ADALAccountInfo adalAccountInfo = new ADALAccountInfo(this, (AuthenticationResult)authResult.get(), this.mOneDriveServiceInfo.get(), this.mLogger);
        this.mAccountInfo.set(adalAccountInfo);
        return this.mAccountInfo.get();
    }

    @Override
    public void logout(final ICallback<Void> logoutCallback) {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        if (logoutCallback == null) {
            throw new IllegalArgumentException("logoutCallback");
        }
        this.mLogger.logDebug("Starting logout async");
        this.mExecutors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    ADALAuthenticator.this.logout();
                    ADALAuthenticator.this.mExecutors.performOnForeground((Void)null, logoutCallback);
                }
                catch (ClientException e) {
                    ADALAuthenticator.this.mExecutors.performOnForeground((Void)null, logoutCallback);
                }
            }
        });
    }

    @Override
    public synchronized void logout() throws ClientException {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        this.mLogger.logDebug("Starting logout");
        this.mLogger.logDebug("Clearing ADAL cache");
        this.mAdalContext.getCache().removeAll();
        this.mLogger.logDebug("Clearing all webview cookies");
        CookieSyncManager.createInstance((Context)this.mActivity);
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.removeAllCookie();
        CookieSyncManager.getInstance().sync();
        this.mLogger.logDebug("Clearing all ADAL Authenticator shared preferences");
        SharedPreferences prefs = this.getSharedPreferences();
        prefs.edit().clear().putInt(VERSION_CODE_KEY, 10200).apply();
        this.mUserId.set(null);
        this.mResourceUrl.set(null);
    }

    private AuthenticationResult getDiscoveryServiceAuthResult(String emailAddressHint) {
        final SimpleWaiter discoveryCallbackWaiter = new SimpleWaiter();
        final AtomicReference error = new AtomicReference();
        final AtomicReference discoveryServiceToken = new AtomicReference();
        AuthenticationCallback<AuthenticationResult> discoveryCallback = new AuthenticationCallback<AuthenticationResult>(){

            public void onSuccess(AuthenticationResult authenticationResult) {
                String userId = authenticationResult.getUserInfo() == null ? "Invalid User Id" : authenticationResult.getUserInfo().getUserId();
                String tenantId = authenticationResult.getTenantId();
                ADALAuthenticator.this.mLogger.logDebug(String.format("Successful response from the discover service for user id '%s', tenant id '%s'", userId, tenantId));
                discoveryServiceToken.set(authenticationResult);
                discoveryCallbackWaiter.signal();
            }

            public void onError(Exception ex) {
                OneDriveErrorCodes code = OneDriveErrorCodes.AuthenticationFailure;
                if (ex instanceof AuthenticationCancelError) {
                    code = OneDriveErrorCodes.AuthenticationCancelled;
                }
                String message = "Error while retrieving the discovery service auth token";
                if (ex instanceof AuthenticationException) {
                    message = String.format("%s; Code %s", message, ((AuthenticationException)ex).getCode().getDescription());
                }
                error.set(new ClientAuthenticatorException(message, ex, code));
                ADALAuthenticator.this.mLogger.logError("Error while attempting to login interactively", (Throwable)error.get());
                discoveryCallbackWaiter.signal();
            }
        };
        this.mLogger.logDebug("Starting interactive login for the discover service access token");
        this.mAdalContext.acquireToken(DISCOVER_SERVICE_RESOURCE_ID, this.getClientId(), this.getRedirectUrl(), emailAddressHint, PromptBehavior.Auto, null, (AuthenticationCallback)discoveryCallback);
        this.mLogger.logDebug("Waiting for interactive login to complete");
        discoveryCallbackWaiter.waitForSignal();
        if (error.get() != null) {
            throw (ClientException)error.get();
        }
        return (AuthenticationResult)discoveryServiceToken.get();
    }

    private SharedPreferences getSharedPreferences() {
        return this.mActivity.getSharedPreferences(ADAL_AUTHENTICATOR_PREFS, 0);
    }

    private ServiceInfo getOneDriveApiService(ServiceInfo[] services) {
        for (ServiceInfo serviceInfo : services) {
            this.mLogger.logDebug(String.format("Service info resource id%s capabilities %s version %s", serviceInfo.serviceResourceId, serviceInfo.capability, serviceInfo.serviceApiVersion));
            if (!serviceInfo.capability.equalsIgnoreCase("MyFiles") || !serviceInfo.serviceApiVersion.equalsIgnoreCase("v2.0")) continue;
            return serviceInfo;
        }
        throw new ClientAuthenticatorException("Unable to file the files services from the directory provider", OneDriveErrorCodes.AuthenticationFailure);
    }

    private ServiceInfo getOneDriveServiceInfoFromDiscoveryService(String accessToken) {
        ArrayList<HeaderOption> options = new ArrayList<HeaderOption>();
        options.add(new HeaderOption("Authorization", "bearer " + accessToken));
        this.mLogger.logDebug("Starting discovery service request");
        BaseRequest discoveryServiceRequest = new BaseRequest(DISCOVERY_SERVICE_URL, null, options, null){};
        discoveryServiceRequest.setHttpMethod(HttpMethod.GET);
        DiscoveryServiceResponse discoveryServiceResponse = this.mHttpProvider.send(discoveryServiceRequest, DiscoveryServiceResponse.class, null);
        return this.getOneDriveApiService(discoveryServiceResponse.services);
    }

    private AuthenticationResult getOneDriveServiceAuthResult(ServiceInfo oneDriveServiceInfo) {
        final SimpleWaiter authorityCallbackWaiter = new SimpleWaiter();
        final AtomicReference error = new AtomicReference();
        final AtomicReference oneDriveServiceAuthToken = new AtomicReference();
        AuthenticationCallback<AuthenticationResult> authorityCallback = new AuthenticationCallback<AuthenticationResult>(){

            public void onSuccess(AuthenticationResult authenticationResult) {
                ADALAuthenticator.this.mLogger.logDebug("Successful refreshed the OneDrive service authentication token");
                oneDriveServiceAuthToken.set(authenticationResult);
                authorityCallbackWaiter.signal();
            }

            public void onError(Exception e) {
                String message = "Error while retrieving the service specific auth token";
                OneDriveErrorCodes code = OneDriveErrorCodes.AuthenticationFailure;
                if (e instanceof AuthenticationCancelError) {
                    code = OneDriveErrorCodes.AuthenticationCancelled;
                }
                if (e instanceof AuthenticationException) {
                    message = String.format("%s; Code %s", message, ((AuthenticationException)e).getCode().getDescription());
                }
                error.set(new ClientAuthenticatorException(message, e, code));
                ADALAuthenticator.this.mLogger.logError("Unable to refresh token into OneDrive service access token", (Throwable)error.get());
                authorityCallbackWaiter.signal();
            }
        };
        this.mLogger.logDebug("Starting OneDrive resource refresh token request");
        this.mAdalContext.acquireToken(this.mActivity, oneDriveServiceInfo.serviceResourceId, this.getClientId(), this.getRedirectUrl(), PromptBehavior.Auto, (AuthenticationCallback)authorityCallback);
        this.mLogger.logDebug("Waiting for token refresh");
        authorityCallbackWaiter.waitForSignal();
        if (error.get() != null) {
            throw (ClientException)error.get();
        }
        return (AuthenticationResult)oneDriveServiceAuthToken.get();
    }
}

