/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.concurrency.IExecutors;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.IThumbnailSetCollectionPage;
import com.onedrive.sdk.extensions.IThumbnailSetCollectionRequest;
import com.onedrive.sdk.extensions.ThumbnailSetCollectionPage;
import com.onedrive.sdk.extensions.ThumbnailSetCollectionRequest;
import com.onedrive.sdk.extensions.ThumbnailSetCollectionRequestBuilder;
import com.onedrive.sdk.generated.BaseThumbnailSetCollectionResponse;
import com.onedrive.sdk.generated.IBaseThumbnailSetCollectionRequest;
import com.onedrive.sdk.http.BaseCollectionRequest;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseThumbnailSetCollectionRequest
extends BaseCollectionRequest<BaseThumbnailSetCollectionResponse, IThumbnailSetCollectionPage>
implements IBaseThumbnailSetCollectionRequest {
    public BaseThumbnailSetCollectionRequest(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options, BaseThumbnailSetCollectionResponse.class, IThumbnailSetCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IThumbnailSetCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseThumbnailSetCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IThumbnailSetCollectionPage get() throws ClientException {
        BaseThumbnailSetCollectionResponse response = (BaseThumbnailSetCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IThumbnailSetCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (ThumbnailSetCollectionRequest)this;
    }

    @Override
    public IThumbnailSetCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (ThumbnailSetCollectionRequest)this;
    }

    @Override
    public IThumbnailSetCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (ThumbnailSetCollectionRequest)this;
    }

    public IThumbnailSetCollectionPage buildFromResponse(BaseThumbnailSetCollectionResponse response) {
        ThumbnailSetCollectionRequestBuilder builder = response.nextLink != null ? new ThumbnailSetCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ThumbnailSetCollectionPage page = new ThumbnailSetCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

