/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.concurrency.IExecutors;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.AllPhotosCollectionPage;
import com.onedrive.sdk.extensions.AllPhotosRequest;
import com.onedrive.sdk.extensions.AllPhotosRequestBuilder;
import com.onedrive.sdk.extensions.IAllPhotosCollectionPage;
import com.onedrive.sdk.extensions.IAllPhotosRequest;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.generated.BaseAllPhotosCollectionResponse;
import com.onedrive.sdk.generated.IBaseAllPhotosRequest;
import com.onedrive.sdk.http.BaseCollectionRequest;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseAllPhotosRequest
extends BaseCollectionRequest<BaseAllPhotosCollectionResponse, IAllPhotosCollectionPage>
implements IBaseAllPhotosRequest {
    public BaseAllPhotosRequest(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options, BaseAllPhotosCollectionResponse.class, IAllPhotosCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IAllPhotosCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseAllPhotosRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IAllPhotosCollectionPage get() throws ClientException {
        BaseAllPhotosCollectionResponse response = (BaseAllPhotosCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IAllPhotosRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (AllPhotosRequest)this;
    }

    @Override
    public IAllPhotosRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (AllPhotosRequest)this;
    }

    @Override
    public IAllPhotosRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (AllPhotosRequest)this;
    }

    public IAllPhotosCollectionPage buildFromResponse(BaseAllPhotosCollectionResponse response) {
        AllPhotosRequestBuilder builder = response.nextLink != null ? new AllPhotosRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        AllPhotosCollectionPage page = new AllPhotosCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

