/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.core;

import com.onedrive.sdk.authentication.ADALAuthenticator;
import com.onedrive.sdk.authentication.AuthorizationInterceptor;
import com.onedrive.sdk.authentication.DisambiguationAuthenticator;
import com.onedrive.sdk.authentication.IAuthenticator;
import com.onedrive.sdk.authentication.MSAAuthenticator;
import com.onedrive.sdk.concurrency.DefaultExecutors;
import com.onedrive.sdk.concurrency.IExecutors;
import com.onedrive.sdk.core.IClientConfig;
import com.onedrive.sdk.http.DefaultHttpProvider;
import com.onedrive.sdk.http.IHttpProvider;
import com.onedrive.sdk.http.IRequestInterceptor;
import com.onedrive.sdk.logger.DefaultLogger;
import com.onedrive.sdk.logger.ILogger;
import com.onedrive.sdk.serializer.DefaultSerializer;
import com.onedrive.sdk.serializer.ISerializer;

public abstract class DefaultClientConfig
implements IClientConfig {
    private IAuthenticator mAuthenticator;
    private IExecutors mExecutors;
    private DefaultHttpProvider mHttpProvider;
    private ILogger mLogger;
    private DefaultSerializer mSerializer;
    private IRequestInterceptor mRequestInterceptor;

    public static IClientConfig createWithAuthenticator(IAuthenticator authenticator) {
        DefaultClientConfig config = new DefaultClientConfig(){};
        config.mAuthenticator = authenticator;
        config.getLogger().logDebug("Using provided authenticator");
        return config;
    }

    public static IClientConfig createWithAuthenticators(MSAAuthenticator msaAuthenticator, ADALAuthenticator adalAuthenticator) {
        DefaultClientConfig config = new DefaultClientConfig(){};
        config.mAuthenticator = new DisambiguationAuthenticator(msaAuthenticator, adalAuthenticator);
        config.getLogger().logDebug("Created DisambiguationAuthenticator");
        return config;
    }

    @Override
    public IAuthenticator getAuthenticator() {
        return this.mAuthenticator;
    }

    @Override
    public IHttpProvider getHttpProvider() {
        if (this.mHttpProvider == null) {
            this.mHttpProvider = new DefaultHttpProvider(this.getSerializer(), this.getRequestInterceptor(), this.getExecutors(), this.getLogger());
            this.mLogger.logDebug("Created DefaultHttpProvider");
        }
        return this.mHttpProvider;
    }

    @Override
    public ISerializer getSerializer() {
        if (this.mSerializer == null) {
            this.mSerializer = new DefaultSerializer(this.getLogger());
            this.mLogger.logDebug("Created DefaultSerializer");
        }
        return this.mSerializer;
    }

    @Override
    public IExecutors getExecutors() {
        if (this.mExecutors == null) {
            this.mExecutors = new DefaultExecutors(this.getLogger());
            this.mLogger.logDebug("Created DefaultExecutors");
        }
        return this.mExecutors;
    }

    @Override
    public ILogger getLogger() {
        if (this.mLogger == null) {
            this.mLogger = new DefaultLogger();
            this.mLogger.logDebug("Created DefaultLogger");
        }
        return this.mLogger;
    }

    private IRequestInterceptor getRequestInterceptor() {
        if (this.mRequestInterceptor == null) {
            this.mRequestInterceptor = new AuthorizationInterceptor(this.getAuthenticator(), this.getLogger());
        }
        return this.mRequestInterceptor;
    }
}

