/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.authentication.adal;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.onedrive.sdk.authentication.ClientAuthenticatorException;
import com.onedrive.sdk.core.OneDriveErrorCodes;
import com.onedrive.sdk.logger.ILogger;

public class BrokerPermissionsChecker {
    private final String mAdalProjectUrl = "https://github.com/AzureAD/azure-activedirectory-library-for-android";
    private final String[] mBrokerRequirePermissions = new String[]{"android.permission.GET_ACCOUNTS", "android.permission.MANAGE_ACCOUNTS", "android.permission.USE_CREDENTIALS"};
    private final Context mContext;
    private final ILogger mLogger;

    public BrokerPermissionsChecker(Context context, ILogger logger) {
        this.mContext = context;
        this.mLogger = logger;
    }

    public void check() throws ClientAuthenticatorException {
        if (!AuthenticationSettings.INSTANCE.getSkipBroker()) {
            this.mLogger.logDebug("Checking permissions for use with the ADAL Broker.");
            for (String permission : this.mBrokerRequirePermissions) {
                if (ContextCompat.checkSelfPermission((Context)this.mContext, (String)permission) != -1) continue;
                String message = String.format("Required permissions to use the Broker are denied: %s, see %s for more details.", permission, "https://github.com/AzureAD/azure-activedirectory-library-for-android");
                this.mLogger.logDebug(message);
                throw new ClientAuthenticatorException(message, OneDriveErrorCodes.AuthenicationPermissionsDenied);
            }
            this.mLogger.logDebug("All required permissions found.");
        }
    }
}

