/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.authentication;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import com.microsoft.services.msa.LiveAuthClient;
import com.microsoft.services.msa.LiveAuthException;
import com.microsoft.services.msa.LiveAuthListener;
import com.microsoft.services.msa.LiveConnectSession;
import com.microsoft.services.msa.LiveStatus;
import com.onedrive.sdk.authentication.ClientAuthenticatorException;
import com.onedrive.sdk.authentication.IAccountInfo;
import com.onedrive.sdk.authentication.IAuthenticator;
import com.onedrive.sdk.authentication.MSAAccountInfo;
import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.concurrency.IExecutors;
import com.onedrive.sdk.concurrency.SimpleWaiter;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.core.OneDriveErrorCodes;
import com.onedrive.sdk.http.IHttpProvider;
import com.onedrive.sdk.logger.ILogger;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public abstract class MSAAuthenticator
implements IAuthenticator {
    private static final String SIGN_IN_CANCELLED_MESSAGE = "The user cancelled the login operation.";
    private static final String MSA_AUTHENTICATOR_PREFS = "MSAAuthenticatorPrefs";
    private static final String USER_ID_KEY = "userId";
    public static final String VERSION_CODE_KEY = "versionCode";
    private static final String DEFAULT_USER_ID = "@@defaultUser";
    private final AtomicReference<String> mUserId = new AtomicReference();
    private IExecutors mExecutors;
    private boolean mInitialized;
    private Activity mActivity;
    private ILogger mLogger;
    private LiveAuthClient mAuthClient;

    public abstract String getClientId();

    public abstract String[] getScopes();

    @Override
    public synchronized void init(IExecutors executors, IHttpProvider httpProvider, Activity activity, ILogger logger) {
        if (this.mInitialized) {
            return;
        }
        this.mExecutors = executors;
        this.mActivity = activity;
        this.mLogger = logger;
        this.mInitialized = true;
        this.mAuthClient = new LiveAuthClient((Context)activity, this.getClientId(), Arrays.asList(this.getScopes()));
        SharedPreferences prefs = this.getSharedPreferences();
        this.mUserId.set(prefs.getString(USER_ID_KEY, null));
    }

    @Override
    public void login(final String emailAddressHint, final ICallback<IAccountInfo> loginCallback) {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        if (loginCallback == null) {
            throw new InvalidParameterException("loginCallback");
        }
        this.mLogger.logDebug("Starting login async");
        this.mExecutors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    MSAAuthenticator.this.mExecutors.performOnForeground(MSAAuthenticator.this.login(emailAddressHint), loginCallback);
                }
                catch (ClientException e) {
                    MSAAuthenticator.this.mExecutors.performOnForeground(e, loginCallback);
                }
            }
        });
    }

    @Override
    public synchronized IAccountInfo login(final String emailAddressHint) throws ClientException {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        this.mLogger.logDebug("Starting login");
        final AtomicReference error = new AtomicReference();
        final SimpleWaiter waiter = new SimpleWaiter();
        final LiveAuthListener listener = new LiveAuthListener(){

            public void onAuthComplete(LiveStatus liveStatus, LiveConnectSession liveConnectSession, Object o) {
                if (liveStatus == LiveStatus.NOT_CONNECTED) {
                    MSAAuthenticator.this.mLogger.logDebug("Received invalid login failure from silent authentication with MSA, ignoring.");
                } else {
                    MSAAuthenticator.this.mLogger.logDebug("Successful interactive login");
                    waiter.signal();
                }
            }

            public void onAuthError(LiveAuthException e, Object o) {
                OneDriveErrorCodes code = OneDriveErrorCodes.AuthenticationFailure;
                if (e.getError().equals(MSAAuthenticator.SIGN_IN_CANCELLED_MESSAGE)) {
                    code = OneDriveErrorCodes.AuthenticationCancelled;
                }
                error.set(new ClientAuthenticatorException("Unable to login with MSA", (Throwable)e, code));
                MSAAuthenticator.this.mLogger.logError(((ClientException)error.get()).getMessage(), (Throwable)error.get());
                waiter.signal();
            }
        };
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MSAAuthenticator.this.mAuthClient.login(MSAAuthenticator.this.mActivity, null, null, emailAddressHint, listener);
            }
        });
        this.mLogger.logDebug("Waiting for MSA callback");
        waiter.waitForSignal();
        ClientException exception = (ClientException)error.get();
        if (exception != null) {
            throw exception;
        }
        String userId = emailAddressHint != null ? emailAddressHint : DEFAULT_USER_ID;
        this.mUserId.set(userId);
        SharedPreferences prefs = this.getSharedPreferences();
        prefs.edit().putString(USER_ID_KEY, this.mUserId.get()).putInt(VERSION_CODE_KEY, 10105).apply();
        return this.getAccountInfo();
    }

    @Override
    public void loginSilent(final ICallback<IAccountInfo> loginCallback) {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        if (loginCallback == null) {
            throw new InvalidParameterException("loginCallback");
        }
        this.mLogger.logDebug("Starting login silent async");
        this.mExecutors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    MSAAuthenticator.this.mExecutors.performOnForeground(MSAAuthenticator.this.loginSilent(), loginCallback);
                }
                catch (ClientException e) {
                    MSAAuthenticator.this.mExecutors.performOnForeground(e, loginCallback);
                }
            }
        });
    }

    @Override
    public synchronized IAccountInfo loginSilent() throws ClientException {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        this.mLogger.logDebug("Starting login silent");
        int userIdStoredMinVersion = 10112;
        if (this.getSharedPreferences().getInt(VERSION_CODE_KEY, 0) >= 10112 && this.mUserId.get() == null) {
            this.mLogger.logDebug("No login information found for silent authentication");
            return null;
        }
        final AtomicReference error = new AtomicReference();
        final SimpleWaiter loginSilentWaiter = new SimpleWaiter();
        boolean waitForCallback = this.mAuthClient.loginSilent(new LiveAuthListener(){

            public void onAuthComplete(LiveStatus liveStatus, LiveConnectSession liveConnectSession, Object o) {
                if (liveStatus == LiveStatus.NOT_CONNECTED) {
                    error.set(new ClientAuthenticatorException("Failed silent login, interactive login required", OneDriveErrorCodes.AuthenticationFailure));
                    MSAAuthenticator.this.mLogger.logError(((ClientException)error.get()).getMessage(), (Throwable)error.get());
                } else {
                    MSAAuthenticator.this.mLogger.logDebug("Successful silent login");
                }
                loginSilentWaiter.signal();
            }

            public void onAuthError(LiveAuthException e, Object o) {
                OneDriveErrorCodes code = OneDriveErrorCodes.AuthenticationFailure;
                if (e.getError().equals(MSAAuthenticator.SIGN_IN_CANCELLED_MESSAGE)) {
                    code = OneDriveErrorCodes.AuthenticationCancelled;
                }
                error.set(new ClientAuthenticatorException("Login silent authentication error", (Throwable)e, code));
                MSAAuthenticator.this.mLogger.logError(((ClientException)error.get()).getMessage(), (Throwable)error.get());
                loginSilentWaiter.signal();
            }
        });
        if (!waitForCallback) {
            this.mLogger.logDebug("MSA silent auth fast-failed");
            return null;
        }
        this.mLogger.logDebug("Waiting for MSA callback");
        loginSilentWaiter.waitForSignal();
        ClientException exception = (ClientException)error.get();
        if (exception != null) {
            throw exception;
        }
        return this.getAccountInfo();
    }

    @Override
    public void logout(final ICallback<Void> logoutCallback) {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        if (logoutCallback == null) {
            throw new InvalidParameterException("logoutCallback");
        }
        this.mLogger.logDebug("Starting logout async");
        this.mExecutors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    MSAAuthenticator.this.logout();
                    MSAAuthenticator.this.mExecutors.performOnForeground((Void)null, logoutCallback);
                }
                catch (ClientException e) {
                    MSAAuthenticator.this.mExecutors.performOnForeground(e, logoutCallback);
                }
            }
        });
    }

    @Override
    public synchronized void logout() throws ClientException {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        this.mLogger.logDebug("Starting logout");
        final SimpleWaiter logoutWaiter = new SimpleWaiter();
        final AtomicReference error = new AtomicReference();
        this.mAuthClient.logout(new LiveAuthListener(){

            public void onAuthComplete(LiveStatus liveStatus, LiveConnectSession liveConnectSession, Object o) {
                MSAAuthenticator.this.mLogger.logDebug("Logout completed");
                logoutWaiter.signal();
            }

            public void onAuthError(LiveAuthException e, Object o) {
                error.set(new ClientAuthenticatorException("MSA Logout failed", (Throwable)e, OneDriveErrorCodes.AuthenticationFailure));
                MSAAuthenticator.this.mLogger.logError(((ClientException)error.get()).getMessage(), (Throwable)error.get());
                logoutWaiter.signal();
            }
        });
        this.mLogger.logDebug("Waiting for logout to complete");
        logoutWaiter.waitForSignal();
        this.mLogger.logDebug("Clearing all MSA Authenticator shared preferences");
        SharedPreferences prefs = this.getSharedPreferences();
        prefs.edit().clear().putInt(VERSION_CODE_KEY, 10105).apply();
        this.mUserId.set(null);
        ClientException exception = (ClientException)error.get();
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public IAccountInfo getAccountInfo() {
        LiveConnectSession session = this.mAuthClient.getSession();
        if (session == null) {
            return null;
        }
        return new MSAAccountInfo(this, session, this.mLogger);
    }

    private SharedPreferences getSharedPreferences() {
        return this.mActivity.getSharedPreferences(MSA_AUTHENTICATOR_PREFS, 0);
    }
}

