/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.onedrive.sdk.extensions.IdentitySet;
import com.onedrive.sdk.extensions.Item;
import com.onedrive.sdk.extensions.ItemCollectionPage;
import com.onedrive.sdk.extensions.Quota;
import com.onedrive.sdk.generated.BaseItemCollectionResponse;
import com.onedrive.sdk.serializer.IJsonBackedObject;
import com.onedrive.sdk.serializer.ISerializer;
import java.util.Arrays;

public class BaseDrive
implements IJsonBackedObject {
    @SerializedName(value="id")
    public String id;
    @SerializedName(value="driveType")
    public String driveType;
    @SerializedName(value="owner")
    public IdentitySet owner;
    @SerializedName(value="quota")
    public Quota quota;
    public transient ItemCollectionPage items;
    public transient ItemCollectionPage shared;
    public transient ItemCollectionPage special;
    private transient JsonObject mRawObject;
    private transient ISerializer mSerializer;

    public JsonObject getRawObject() {
        return this.mRawObject;
    }

    protected ISerializer getSerializer() {
        return this.mSerializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        int i;
        Item[] array;
        JsonObject[] sourceArray;
        BaseItemCollectionResponse response;
        this.mSerializer = serializer;
        this.mRawObject = json;
        if (json.has("items")) {
            response = new BaseItemCollectionResponse();
            if (json.has("items@odata.nextLink")) {
                response.nextLink = json.get("items@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("items").toString(), JsonObject[].class);
            array = new Item[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Item.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.items = new ItemCollectionPage(response, null);
        }
        if (json.has("shared")) {
            response = new BaseItemCollectionResponse();
            if (json.has("shared@odata.nextLink")) {
                response.nextLink = json.get("shared@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("shared").toString(), JsonObject[].class);
            array = new Item[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Item.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.shared = new ItemCollectionPage(response, null);
        }
        if (json.has("special")) {
            response = new BaseItemCollectionResponse();
            if (json.has("special@odata.nextLink")) {
                response.nextLink = json.get("special@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("special").toString(), JsonObject[].class);
            array = new Item[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Item.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.special = new ItemCollectionPage(response, null);
        }
    }
}

