/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.http;

import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.http.BaseRequest;
import com.onedrive.sdk.http.HttpMethod;
import com.onedrive.sdk.http.IHttpRequest;
import com.onedrive.sdk.options.HeaderOption;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.net.URL;
import java.util.List;

public abstract class BaseCollectionRequest<T1, T2>
implements IHttpRequest {
    private final BaseRequest mBaseRequest;
    private final Class<T1> mResponseClass;
    private final Class<T2> mCollectionPageClass;

    public BaseCollectionRequest(String requestUrl, IOneDriveClient client, List<Option> options, Class<T1> responseClass, Class<T2> collectionPageClass) {
        this.mResponseClass = responseClass;
        this.mCollectionPageClass = collectionPageClass;
        this.mBaseRequest = new BaseRequest(requestUrl, client, options, this.mResponseClass){};
        this.mBaseRequest.setHttpMethod(HttpMethod.GET);
    }

    protected T1 send() throws ClientException {
        return this.mBaseRequest.getClient().getHttpProvider().send(this, this.mResponseClass, null);
    }

    @Override
    public URL getRequestUrl() {
        return this.mBaseRequest.getRequestUrl();
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.mBaseRequest.getHttpMethod();
    }

    @Override
    public List<HeaderOption> getHeaders() {
        return this.mBaseRequest.getHeaders();
    }

    @Override
    public void addHeader(String header, String value) {
        this.mBaseRequest.addHeader(header, value);
    }

    @Override
    public List<Option> getOptions() {
        return this.mBaseRequest.getOptions();
    }

    public void addQueryOption(QueryOption option) {
        this.mBaseRequest.getQueryOptions().add(option);
    }

    protected BaseRequest getBaseRequest() {
        return this.mBaseRequest;
    }

    public Class<T2> getCollectionPageClass() {
        return this.mCollectionPageClass;
    }
}

