/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.authentication;

import com.microsoft.aad.adal.AuthenticationResult;
import com.onedrive.sdk.authentication.ADALAuthenticator;
import com.onedrive.sdk.authentication.AccountType;
import com.onedrive.sdk.authentication.IAccountInfo;
import com.onedrive.sdk.authentication.ServiceInfo;
import com.onedrive.sdk.logger.ILogger;

public class ADALAccountInfo
implements IAccountInfo {
    private final ADALAuthenticator mAuthenticator;
    private AuthenticationResult mAuthenticationResult;
    private final ServiceInfo mOneDriveServiceInfo;
    private final ILogger mLogger;

    public ADALAccountInfo(ADALAuthenticator authenticator, AuthenticationResult authenticationResult, ServiceInfo oneDriveServiceInfo, ILogger logger) {
        this.mAuthenticator = authenticator;
        this.mAuthenticationResult = authenticationResult;
        this.mOneDriveServiceInfo = oneDriveServiceInfo;
        this.mLogger = logger;
    }

    @Override
    public AccountType getAccountType() {
        return AccountType.ActiveDirectory;
    }

    @Override
    public String getAccessToken() {
        return this.mAuthenticationResult.getAccessToken();
    }

    @Override
    public String getServiceRoot() {
        return this.mOneDriveServiceInfo.serviceEndpointUri;
    }

    @Override
    public boolean isExpired() {
        return this.mAuthenticationResult.isExpired();
    }

    @Override
    public void refresh() {
        this.mLogger.logDebug("Refreshing access token...");
        ADALAccountInfo newInfo = (ADALAccountInfo)this.mAuthenticator.loginSilent();
        this.mAuthenticationResult = newInfo.mAuthenticationResult;
    }
}

