/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.authentication;

import android.graphics.Bitmap;
import android.net.Uri;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.onedrive.sdk.authentication.AccountType;
import com.onedrive.sdk.authentication.ClientAuthenticatorException;
import com.onedrive.sdk.authentication.DisambiguationDialog;
import com.onedrive.sdk.authentication.DisambiguationResponse;
import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.core.OneDriveErrorCodes;
import java.util.Locale;

class DisambiguationWebView
extends WebViewClient {
    private final DisambiguationDialog mDisambiguationDialog;
    private final ICallback<DisambiguationResponse> mCallback;

    public DisambiguationWebView(DisambiguationDialog disambiguationDialog, ICallback<DisambiguationResponse> callback) {
        this.mDisambiguationDialog = disambiguationDialog;
        this.mCallback = callback;
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        this.mDisambiguationDialog.getLogger().logDebug("onPageStarted for url '" + url + "'");
        super.onPageStarted(view, url, favicon);
        Uri uri = Uri.parse((String)url);
        if (uri.getAuthority().equalsIgnoreCase("localhost:777")) {
            this.mDisambiguationDialog.getLogger().logDebug("Found callback from disambiguation service");
            AccountType accountType = AccountType.fromRepresentation(uri.getQueryParameter("account_type"));
            String account = uri.getQueryParameter("user_email");
            this.mCallback.success(new DisambiguationResponse(accountType, account));
            view.stopLoading();
            this.mDisambiguationDialog.dismiss();
        }
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        String errorMessage = String.format(Locale.ROOT, "Url %s, Error code: %d, Description %s", failingUrl, errorCode, description);
        this.mCallback.failure(new ClientAuthenticatorException(errorMessage, OneDriveErrorCodes.AuthenticationFailure));
        this.mDisambiguationDialog.dismiss();
    }
}

