// ------------------------------------------------------------------------------
// Copyright (c) 2015 Microsoft Corporation
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
// ------------------------------------------------------------------------------

package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.*;
import com.onedrive.sdk.core.*;
import com.onedrive.sdk.extensions.*;
import com.onedrive.sdk.http.*;
import com.onedrive.sdk.generated.*;
import com.onedrive.sdk.options.*;
import com.onedrive.sdk.serializer.*;

import java.util.*;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Create Link Request.
 */
public class BaseCreateLinkRequest extends BaseRequest implements IBaseCreateLinkRequest {
    protected final CreateLinkBody mBody;

    /**
     * The request for this CreateLink
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseCreateLinkRequest(final String requestUrl, final IOneDriveClient client, final List<Option> options, final String type) {
        super(requestUrl, client, options, Permission.class);
        mBody = new CreateLinkBody();
        mBody.type = type;
    }

    public void create(final ICallback<Permission> callback) {
        send(HttpMethod.POST, callback, mBody);
    }

    public Permission create() throws ClientException {
        return send(HttpMethod.POST, mBody);
    }

    public ICreateLinkRequest select(final String value) {
        getQueryOptions().add(new QueryOption("select", value));
        return (CreateLinkRequest)this;
    }

    public ICreateLinkRequest top(final int value) {
        getQueryOptions().add(new QueryOption("top", value+""));
        return (CreateLinkRequest)this;
    }

    public ICreateLinkRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("expand", value));
        return (CreateLinkRequest)this;
    }
}
