/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.onedrive.sdk.logger.ILogger;
import com.onedrive.sdk.serializer.CalendarSerializer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Calendar;

final class GsonFactory {
    private GsonFactory() {
    }

    public static Gson getGsonInstance(final ILogger logger) {
        JsonSerializer<Calendar> dateJsonSerializer = new JsonSerializer<Calendar>(){

            public JsonElement serialize(Calendar src, Type typeOfSrc, JsonSerializationContext context) {
                if (src == null) {
                    return null;
                }
                try {
                    return new JsonPrimitive(CalendarSerializer.serialize(src));
                }
                catch (Exception e) {
                    logger.logError("Parsing issue on " + src, e);
                    return null;
                }
            }
        };
        JsonDeserializer<Calendar> dateJsonDeserializer = new JsonDeserializer<Calendar>(){

            public Calendar deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json == null) {
                    return null;
                }
                try {
                    return CalendarSerializer.deserialize(json.getAsString());
                }
                catch (ParseException e) {
                    logger.logError("Parsing issue on " + json.getAsString(), e);
                    return null;
                }
            }
        };
        return new GsonBuilder().registerTypeAdapter(Calendar.class, (Object)dateJsonSerializer).registerTypeAdapter(Calendar.class, (Object)dateJsonDeserializer).create();
    }
}

