/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.authentication;

import com.onedrive.sdk.authentication.IAuthenticator;
import com.onedrive.sdk.http.IHttpRequest;
import com.onedrive.sdk.http.IRequestInterceptor;
import com.onedrive.sdk.logger.ILogger;
import com.onedrive.sdk.options.HeaderOption;

public class AuthorizationInterceptor
implements IRequestInterceptor {
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    public static final String OAUTH_BEARER_PREFIX = "bearer ";
    private final IAuthenticator mAuthenticator;
    private final ILogger mLogger;

    public AuthorizationInterceptor(IAuthenticator authenticator, ILogger logger) {
        this.mAuthenticator = authenticator;
        this.mLogger = logger;
    }

    @Override
    public void intercept(IHttpRequest request) {
        this.mLogger.logDebug("Intercepting request, " + request.getRequestUrl());
        for (HeaderOption option : request.getHeaders()) {
            if (!option.getName().equals(AUTHORIZATION_HEADER_NAME)) continue;
            this.mLogger.logDebug("Found an existing authorization header!");
            return;
        }
        if (this.mAuthenticator.getAccountInfo() != null) {
            this.mLogger.logDebug("Found account information");
            if (this.mAuthenticator.getAccountInfo().isExpired()) {
                this.mLogger.logDebug("Account access token is expired, refreshing");
                this.mAuthenticator.getAccountInfo().refresh();
            }
            String accessToken = this.mAuthenticator.getAccountInfo().getAccessToken();
            request.addHeader(AUTHORIZATION_HEADER_NAME, OAUTH_BEARER_PREFIX + accessToken);
        } else {
            this.mLogger.logDebug("No active account found, skipping writing auth header");
        }
    }
}

