/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.http;

import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.http.IRequestBuilder;
import com.onedrive.sdk.options.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseRequestBuilder
implements IRequestBuilder {
    private final IOneDriveClient mClient;
    private final String mRequestUrl;
    private final List<Option> mOptions = new ArrayList<Option>();

    public BaseRequestBuilder(String requestUrl, IOneDriveClient client, List<Option> options) {
        this.mRequestUrl = requestUrl;
        this.mClient = client;
        if (options != null) {
            this.mOptions.addAll(options);
        }
    }

    @Override
    public IOneDriveClient getClient() {
        return this.mClient;
    }

    @Override
    public String getRequestUrl() {
        return this.mRequestUrl;
    }

    public List<Option> getOptions() {
        return Collections.unmodifiableList(this.mOptions);
    }

    @Override
    public String getRequestUrlWithAdditionalSegment(String urlSegment) {
        return this.mRequestUrl + "/" + urlSegment;
    }
}

