/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.IShareCollectionPage;
import com.onedrive.sdk.extensions.IShareCollectionRequest;
import com.onedrive.sdk.extensions.ShareCollectionPage;
import com.onedrive.sdk.extensions.ShareCollectionRequest;
import com.onedrive.sdk.extensions.ShareCollectionRequestBuilder;
import com.onedrive.sdk.generated.BaseShareCollectionResponse;
import com.onedrive.sdk.generated.IBaseShareCollectionRequest;
import com.onedrive.sdk.http.BaseCollectionRequest;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseShareCollectionRequest
extends BaseCollectionRequest<BaseShareCollectionResponse, IShareCollectionPage>
implements IBaseShareCollectionRequest {
    public BaseShareCollectionRequest(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options, BaseShareCollectionResponse.class, IShareCollectionPage.class);
    }

    @Override
    public IShareCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (ShareCollectionRequest)this;
    }

    @Override
    public IShareCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (ShareCollectionRequest)this;
    }

    @Override
    public IShareCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (ShareCollectionRequest)this;
    }

    public IShareCollectionPage buildFromResponse(BaseShareCollectionResponse response) {
        ShareCollectionRequestBuilder builder = response.nextLink != null ? new ShareCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ShareCollectionPage page = new ShareCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

