/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.concurrency.IExecutors;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.IPermissionCollectionPage;
import com.onedrive.sdk.extensions.IPermissionCollectionRequest;
import com.onedrive.sdk.extensions.PermissionCollectionPage;
import com.onedrive.sdk.extensions.PermissionCollectionRequest;
import com.onedrive.sdk.extensions.PermissionCollectionRequestBuilder;
import com.onedrive.sdk.generated.BasePermissionCollectionResponse;
import com.onedrive.sdk.generated.IBasePermissionCollectionRequest;
import com.onedrive.sdk.http.BaseCollectionRequest;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BasePermissionCollectionRequest
extends BaseCollectionRequest<BasePermissionCollectionResponse, IPermissionCollectionPage>
implements IBasePermissionCollectionRequest {
    public BasePermissionCollectionRequest(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options, BasePermissionCollectionResponse.class, IPermissionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IPermissionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BasePermissionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPermissionCollectionPage get() throws ClientException {
        BasePermissionCollectionResponse response = (BasePermissionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IPermissionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (PermissionCollectionRequest)this;
    }

    @Override
    public IPermissionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (PermissionCollectionRequest)this;
    }

    @Override
    public IPermissionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (PermissionCollectionRequest)this;
    }

    public IPermissionCollectionPage buildFromResponse(BasePermissionCollectionResponse response) {
        PermissionCollectionRequestBuilder builder = response.nextLink != null ? new PermissionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PermissionCollectionPage page = new PermissionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

