/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.ChunkedUploadSessionDescriptor;
import com.onedrive.sdk.extensions.CreateSessionBody;
import com.onedrive.sdk.extensions.CreateSessionRequest;
import com.onedrive.sdk.extensions.ICreateSessionRequest;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.UploadSession;
import com.onedrive.sdk.generated.IBaseCreateSessionRequest;
import com.onedrive.sdk.http.BaseRequest;
import com.onedrive.sdk.http.HttpMethod;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseCreateSessionRequest
extends BaseRequest
implements IBaseCreateSessionRequest {
    protected final CreateSessionBody mBody = new CreateSessionBody();

    public BaseCreateSessionRequest(String requestUrl, IOneDriveClient client, List<Option> options, ChunkedUploadSessionDescriptor item) {
        super(requestUrl, client, options, UploadSession.class);
        this.mBody.item = item;
    }

    @Override
    public void create(ICallback<UploadSession> callback) {
        this.send(HttpMethod.POST, callback, this.mBody);
    }

    @Override
    public UploadSession create() throws ClientException {
        return (UploadSession)this.send(HttpMethod.POST, this.mBody);
    }

    @Override
    public ICreateSessionRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("select", value));
        return (CreateSessionRequest)this;
    }

    @Override
    public ICreateSessionRequest top(int value) {
        this.getQueryOptions().add(new QueryOption("top", value + ""));
        return (CreateSessionRequest)this;
    }

    @Override
    public ICreateSessionRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("expand", value));
        return (CreateSessionRequest)this;
    }
}

