/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.authentication;

public enum AccountType {
    MicrosoftAccount("MSA"),
    ActiveDirectory("AAD");

    private final String[] mRepresentations;

    private AccountType(String ... representations) {
        this.mRepresentations = representations;
    }

    public static AccountType fromRepresentation(String representation) {
        for (AccountType accountType : AccountType.values()) {
            for (String possibleRepresentation : accountType.mRepresentations) {
                if (!possibleRepresentation.equalsIgnoreCase(representation)) continue;
                return accountType;
            }
        }
        String message = String.format("Unable to find a representation for '%s", representation);
        throw new UnsupportedOperationException(message);
    }
}

