/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.spring.boot.oauth.AuthoritiesProvider;
import com.okta.spring.boot.oauth.ReactiveOktaOAuth2UserService;
import com.okta.spring.boot.oauth.UserUtil;
import java.util.Collection;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.ReactiveOAuth2UserService;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import reactor.core.publisher.Mono;

final class ReactiveOktaOidcUserService
extends OidcReactiveOAuth2UserService {
    private final Collection<AuthoritiesProvider> authoritiesProviders;

    ReactiveOktaOidcUserService(Collection<AuthoritiesProvider> authoritiesProviders) {
        this(authoritiesProviders, (ReactiveOAuth2UserService<OAuth2UserRequest, OAuth2User>)new ReactiveOktaOAuth2UserService(authoritiesProviders));
    }

    ReactiveOktaOidcUserService(Collection<AuthoritiesProvider> authoritiesProviders, ReactiveOAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService) {
        this.authoritiesProviders = authoritiesProviders;
        this.setOauth2UserService(oauth2UserService);
    }

    public Mono<OidcUser> loadUser(OidcUserRequest userRequest) {
        return super.loadUser(userRequest).map(user -> UserUtil.decorateUser(user, userRequest, this.authoritiesProviders));
    }
}

