/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.spring.boot.oauth.TokenUtil;
import com.okta.spring.boot.oauth.config.OktaOAuth2Properties;
import java.util.Collection;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;

final class OktaJwtAuthenticationConverter
extends JwtAuthenticationConverter {
    public OktaJwtAuthenticationConverter(String groupClaim) {
        JwtGrantedAuthoritiesConverter originalConverter = new JwtGrantedAuthoritiesConverter();
        this.setJwtGrantedAuthoritiesConverter(source -> {
            Collection result = originalConverter.convert(source);
            result.addAll(TokenUtil.tokenClaimsToAuthorities(source.getClaims(), groupClaim));
            return result;
        });
    }

    public OktaJwtAuthenticationConverter(OktaOAuth2Properties oktaOAuth2Properties) {
        JwtGrantedAuthoritiesConverter originalConverter = new JwtGrantedAuthoritiesConverter();
        if (oktaOAuth2Properties.getAuthoritiesClaimName() != null) {
            originalConverter.setAuthoritiesClaimName(oktaOAuth2Properties.getAuthoritiesClaimName());
        }
        this.setJwtGrantedAuthoritiesConverter(source -> {
            Collection result = originalConverter.convert(source);
            result.addAll(TokenUtil.tokenClaimsToAuthorities(source.getClaims(), oktaOAuth2Properties.getGroupsClaim()));
            return result;
        });
    }
}

