/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.spring.boot.oauth.AuthoritiesProvider;
import com.okta.spring.boot.oauth.TokenUtil;
import com.okta.spring.boot.oauth.config.OktaOAuth2Properties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class AuthorityProvidersConfig {
    AuthorityProvidersConfig() {
    }

    @Bean
    AuthoritiesProvider tokenScopesAuthoritiesProvider() {
        return (user, userRequest) -> TokenUtil.tokenScopesToAuthorities(userRequest.getAccessToken());
    }

    @Bean
    AuthoritiesProvider groupClaimsAuthoritiesProvider(OktaOAuth2Properties oktaOAuth2Properties) {
        return (user, userRequest) -> TokenUtil.tokenClaimsToAuthorities(user.getAttributes(), oktaOAuth2Properties.getGroupsClaim());
    }
}

