/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.spring.boot.oauth.Okta;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

final class BrowserFriendlyBearerTokenServerAuthenticationEntryPoint
implements ServerAuthenticationEntryPoint {
    private String realmName;

    BrowserFriendlyBearerTokenServerAuthenticationEntryPoint() {
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public Mono<Void> commence(ServerWebExchange exchange, AuthenticationException authException) {
        return Mono.defer(() -> {
            HttpStatus status = this.getStatus(authException);
            Map<String, String> parameters = this.createParameters(authException);
            String wwwAuthenticate = BrowserFriendlyBearerTokenServerAuthenticationEntryPoint.computeWWWAuthenticateHeaderValue(parameters);
            ServerHttpResponse response = exchange.getResponse();
            response.getHeaders().set("WWW-Authenticate", wwwAuthenticate);
            response.setStatusCode((HttpStatusCode)status);
            response.getHeaders().setContentType(MediaType.TEXT_PLAIN);
            DataBuffer buffer = response.bufferFactory().wrap(Okta.statusAsString(status).getBytes(StandardCharsets.UTF_8));
            return response.writeWith((Publisher)Mono.just((Object)buffer));
        });
    }

    private Map<String, String> createParameters(AuthenticationException authException) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (this.realmName != null) {
            parameters.put("realm", this.realmName);
        }
        if (authException instanceof OAuth2AuthenticationException) {
            BearerTokenError bearerTokenError;
            OAuth2Error error = ((OAuth2AuthenticationException)authException).getError();
            parameters.put("error", error.getErrorCode());
            if (StringUtils.hasText((String)error.getDescription())) {
                parameters.put("error_description", error.getDescription());
            }
            if (StringUtils.hasText((String)error.getUri())) {
                parameters.put("error_uri", error.getUri());
            }
            if (error instanceof BearerTokenError && StringUtils.hasText((String)(bearerTokenError = (BearerTokenError)error).getScope())) {
                parameters.put("scope", bearerTokenError.getScope());
            }
        }
        return parameters;
    }

    private HttpStatus getStatus(AuthenticationException authException) {
        return Okta.getStatus(authException);
    }

    private static String computeWWWAuthenticateHeaderValue(Map<String, String> parameters) {
        String wwwAuthenticate = "Bearer";
        if (!parameters.isEmpty()) {
            wwwAuthenticate = wwwAuthenticate + parameters.entrySet().stream().map(attribute -> (String)attribute.getKey() + "=\"" + (String)attribute.getValue() + "\"").collect(Collectors.joining(", ", " ", ""));
        }
        return wwwAuthenticate;
    }
}

